/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import com.google.common.base.Predicates;

import net.fabricmc.fabric.api.entity.EntityPickInteractionAware;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2392;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import vazkii.botania.api.corporea.ICorporeaNode;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.common.impl.corporea.DummyCorporeaNode;
import vazkii.botania.common.integration.corporea.CorporeaNodeDetectors;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.common.network.PacketSpawnEntity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;

public class EntityCorporeaSpark extends EntitySparkBase implements ICorporeaSpark, EntityPickInteractionAware {
	private static final int SCAN_RANGE = 8;

	private static final String TAG_MASTER = "master";

	private static final class_2940<Boolean> MASTER = class_2945.method_12791(EntityCorporeaSpark.class, class_2943.field_13323);

	private ICorporeaSpark master;
	private List<ICorporeaSpark> connections = new ArrayList<>();
	private List<ICorporeaSpark> relatives = new ArrayList<>();
	private boolean firstTick = true;

	public EntityCorporeaSpark(class_1299<EntityCorporeaSpark> type, class_1937 world) {
		super(type, world);
	}

	@Override
	protected void method_5693() {
		super.method_5693();
		field_6011.method_12784(MASTER, false);
	}

	@Nonnull
	@Override
	public class_1799 getPickedStack(@Nullable class_1657 player, class_239 target) {
		return isMaster() ? new class_1799(ModItems.corporeaSparkMaster) : new class_1799(ModItems.corporeaSpark);
	}

	@Override
	public void method_5773() {
		super.method_5773();

		if (field_6002.field_9236) {
			return;
		}

		ICorporeaNode node = getSparkNode();
		if (node instanceof DummyCorporeaNode && !field_6002.method_8320(getAttachPos()).method_26164(ModTags.Blocks.CORPOREA_SPARK_OVERRIDE)) {
			dropAndKill();
			return;
		}

		if (isMaster()) {
			master = this;
		}

		if (firstTick) {
			if (isMaster()) {
				restartNetwork();
			} else {
				findNetwork();
			}

			firstTick = false;
		}

		if (master != null && (((class_1297) master).field_5988 || master.getNetwork() != getNetwork())) {
			master = null;
		}
	}

	private void dropAndKill() {
		method_5699(new class_1799(isMaster() ? ModItems.corporeaSparkMaster : ModItems.corporeaSpark), 0F);
		method_5650();
	}

	@Override
	public void method_5650() {
		super.method_5650();
		connections.remove(this);
		restartNetwork();
	}

	@Override
	public void registerConnections(ICorporeaSpark master, ICorporeaSpark referrer, List<ICorporeaSpark> connections) {
		relatives.clear();
		for (ICorporeaSpark spark : getNearbySparks()) {
			if (spark == null || connections.contains(spark) || spark.getNetwork() != getNetwork() || spark.isMaster() || ((class_1297) spark).field_5988) {
				continue;
			}

			connections.add(spark);
			relatives.add(spark);
			spark.registerConnections(master, this, connections);
		}

		this.master = master;
		this.connections = connections;
	}

	@SuppressWarnings("unchecked")
	private List<ICorporeaSpark> getNearbySparks() {
		return (List) field_6002.method_8390(class_1297.class, new class_238(method_23317() - SCAN_RANGE, method_23318() - SCAN_RANGE, method_23321() - SCAN_RANGE, method_23317() + SCAN_RANGE, method_23318() + SCAN_RANGE, method_23321() + SCAN_RANGE), Predicates.instanceOf(ICorporeaSpark.class));
	}

	private void restartNetwork() {
		connections = new ArrayList<>();
		relatives = new ArrayList<>();

		if (master != null) {
			ICorporeaSpark oldMaster = master;
			master = null;

			oldMaster.registerConnections(oldMaster, this, new ArrayList<>());
		}
	}

	private void findNetwork() {
		for (ICorporeaSpark spark : getNearbySparks()) {
			if (spark.getNetwork() == getNetwork() && !((class_1297) spark).field_5988) {
				ICorporeaSpark master = spark.getMaster();
				if (master != null) {
					this.master = master;
					restartNetwork();

					break;
				}
			}
		}
	}

	private static void displayRelatives(class_1657 player, List<ICorporeaSpark> checked, ICorporeaSpark spark) {
		if (spark == null) {
			return;
		}

		List<ICorporeaSpark> sparks = spark.getRelatives();
		if (sparks.isEmpty()) {
			EntitySpark.particleBeam(player, (class_1297) spark, (class_1297) spark.getMaster());
		} else {
			for (ICorporeaSpark endSpark : sparks) {
				if (!checked.contains(endSpark)) {
					EntitySpark.particleBeam(player, (class_1297) spark, (class_1297) endSpark);
					checked.add(endSpark);
					displayRelatives(player, checked, endSpark);
				}
			}
		}
	}

	@Override
	public class_2338 getAttachPos() {
		int x = class_3532.method_15357(method_23317());
		int y = class_3532.method_15357(method_23318() - 1);
		int z = class_3532.method_15357(method_23321());
		return new class_2338(x, y, z);
	}

	@Override
	public ICorporeaNode getSparkNode() {
		return CorporeaNodeDetectors.findNode(field_6002, this);
	}

	@Override
	public List<ICorporeaSpark> getConnections() {
		return connections;
	}

	@Override
	public List<ICorporeaSpark> getRelatives() {
		return relatives;
	}

	@Override
	public void onItemExtracted(class_1799 stack) {
		((class_3218) field_6002).method_14199(new class_2392(class_2398.field_11218, stack), method_23317(), method_23318(), method_23321(), 10, 0.125, 0.125, 0.125, 0.05);
	}

	@Override
	public void onItemsRequested(List<class_1799> stacks) {
		List<class_1792> shownItems = new ArrayList<>();
		for (class_1799 stack : stacks) {
			if (!shownItems.contains(stack.method_7909())) {
				shownItems.add(stack.method_7909());
				((class_3218) field_6002).method_14199(new class_2392(class_2398.field_11218, stack), method_23317(), method_23318(), method_23321(), 10, 0.125, 0.125, 0.125, 0.05);
			}
		}
	}

	@Override
	public ICorporeaSpark getMaster() {
		return master;
	}

	public void setMaster(boolean master) {
		field_6011.method_12778(MASTER, master);
	}

	@Override
	public boolean isMaster() {
		return field_6011.method_12789(MASTER);
	}

	@Override
	public class_1269 method_5688(class_1657 player, class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		if (!field_5988 && !stack.method_7960()) {
			if (stack.method_7909() == ModItems.twigWand) {
				if (!field_6002.field_9236) {
					if (player.method_5715()) {
						dropAndKill();
						if (isMaster()) {
							restartNetwork();
						}
					} else {
						displayRelatives(player, new ArrayList<>(), master);
					}
				}
				return class_1269.method_29236(field_6002.field_9236);
			} else if (stack.method_7909() instanceof class_1769) {
				class_1767 color = ((class_1769) stack.method_7909()).method_7802();
				if (color != getNetwork()) {
					if (!field_6002.field_9236) {
						setNetwork(color);

						stack.method_7934(1);
					}

					return class_1269.method_29236(field_6002.field_9236);
				}
			} else if (stack.method_7909() == ModItems.phantomInk) {
				if (!field_6002.field_9236) {
					method_5648(true);
				}
				return class_1269.method_29236(field_6002.field_9236);
			}
		}

		return class_1269.field_5811;
	}

	@Override
	public void setNetwork(class_1767 color) {
		if (color == getNetwork()) {
			return;
		}

		super.setNetwork(color);

		// Do not access world during deserialization
		if (!firstTick) {
			if (isMaster()) {
				restartNetwork();
			} else {
				findNetwork();
			}
		}
	}

	@Nonnull
	@Override
	public class_2596<?> method_18002() {
		return PacketSpawnEntity.make(this);
	}

	@Override
	protected void method_5749(@Nonnull class_2487 cmp) {
		super.method_5749(cmp);
		setMaster(cmp.method_10577(TAG_MASTER));
	}

	@Override
	protected void method_5652(@Nonnull class_2487 cmp) {
		super.method_5652(cmp);
		cmp.method_10556(TAG_MASTER, isMaster());
	}

}
