/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.relic.ItemKingKey;
import vazkii.botania.common.network.PacketSpawnEntity;

import javax.annotation.Nonnull;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import java.util.List;

public class EntityBabylonWeapon extends EntityThrowableCopy {
	private static final String TAG_CHARGING = "charging";
	private static final String TAG_VARIETY = "variety";
	private static final String TAG_CHARGE_TICKS = "chargeTicks";
	private static final String TAG_LIVE_TICKS = "liveTicks";
	private static final String TAG_DELAY = "delay";
	private static final String TAG_ROTATION = "rotation";

	private static final class_2940<Boolean> CHARGING = class_2945.method_12791(EntityBabylonWeapon.class, class_2943.field_13323);
	private static final class_2940<Integer> VARIETY = class_2945.method_12791(EntityBabylonWeapon.class, class_2943.field_13327);
	private static final class_2940<Integer> CHARGE_TICKS = class_2945.method_12791(EntityBabylonWeapon.class, class_2943.field_13327);
	private static final class_2940<Integer> LIVE_TICKS = class_2945.method_12791(EntityBabylonWeapon.class, class_2943.field_13327);
	private static final class_2940<Integer> DELAY = class_2945.method_12791(EntityBabylonWeapon.class, class_2943.field_13327);
	private static final class_2940<Float> ROTATION = class_2945.method_12791(EntityBabylonWeapon.class, class_2943.field_13320);

	public EntityBabylonWeapon(class_1299<EntityBabylonWeapon> type, class_1937 world) {
		super(type, world);
	}

	public EntityBabylonWeapon(class_1309 thrower, class_1937 world) {
		super(ModEntities.BABYLON_WEAPON, thrower, world);
	}

	@Override
	protected void method_5693() {
		field_6011.method_12784(CHARGING, false);
		field_6011.method_12784(VARIETY, 0);
		field_6011.method_12784(CHARGE_TICKS, 0);
		field_6011.method_12784(LIVE_TICKS, 0);
		field_6011.method_12784(DELAY, 0);
		field_6011.method_12784(ROTATION, 0F);
	}

	@Override
	public class_2596<?> method_18002() {
		return PacketSpawnEntity.make(this);
	}

	@Override
	public boolean method_5640(double dist) {
		return dist < 64 * 64;
	}

	@Override
	public boolean method_5659() {
		return true;
	}

	@Override
	public void method_5773() {
		class_1297 thrower = method_24921();
		if (!field_6002.field_9236 && (thrower == null || !(thrower instanceof class_1657) || thrower.field_5988)) {
			method_5650();
			return;
		}
		class_1657 player = (class_1657) thrower;
		if (!field_6002.field_9236) {
			class_1799 stack = PlayerHelper.getFirstHeldItem(player, ModItems.kingKey);
			boolean newCharging = !stack.method_7960() && ItemKingKey.isCharging(stack);
			if (isCharging() != newCharging) {
				setCharging(newCharging);
			}
		}

		class_243 mot = method_18798();

		int liveTime = getLiveTicks();
		int delay = getDelay();
		boolean charging = isCharging() && liveTime == 0;

		if (charging) {
			method_18799(class_243.field_1353);

			int chargeTime = getChargeTicks();
			setChargeTicks(chargeTime + 1);

			if (field_6002.field_9229.nextInt(20) == 0) {
				field_6002.method_8465(null, method_23317(), method_23318(), method_23321(), ModSounds.babylonSpawn, class_3419.field_15248, 0.1F, 1F + field_6002.field_9229.nextFloat() * 3F);
			}
		} else {
			if (liveTime < delay) {
				method_18799(class_243.field_1353);
			} else if (liveTime == delay && player != null) {
				class_243 playerLook;
				class_3965 rtr = ToolCommons.raytraceFromEntity(player, 64, true);
				if (rtr.method_17783() != class_239.class_240.field_1332) {
					playerLook = player.method_5720().method_1021(64).method_1019(player.method_19538());
				} else {
					playerLook = class_243.method_24953(rtr.method_17777());
				}

				Vector3 thisVec = Vector3.fromEntityCenter(this);

				mot = playerLook.method_1023(thisVec.x, thisVec.y, thisVec.z).method_1029().method_1021(2);
				field_6002.method_8465(null, method_23317(), method_23318(), method_23321(), ModSounds.babylonAttack, class_3419.field_15248, 2F, 0.1F + field_6002.field_9229.nextFloat() * 3F);
			}

			if (!field_6002.field_9236) {
				setLiveTicks(liveTime + 1);
				class_238 axis = new class_238(method_23317(), method_23318(), method_23321(), field_6038, field_5971, field_5989).method_1014(2);
				List<class_1309> entities = field_6002.method_18467(class_1309.class, axis);
				for (class_1309 living : entities) {
					if (living == thrower) {
						continue;
					}

					if (living.field_6235 == 0) {
						if (player != null) {
							living.method_5643(class_1282.method_5532(player), 20);
						} else {
							living.method_5643(class_1282.field_5869, 20);
						}
						method_7488(new class_3966(living));
						return;
					}
				}
			}
		}

		super.method_5773();

		// Apply after super tick so drag is not applied by super
		method_18799(mot);

		if (field_6002.field_9236 && liveTime > delay) {
			WispParticleData data = WispParticleData.wisp(0.3F, 1F, 1F, 0F, 1);
			field_6002.method_8406(data, method_23317(), method_23318(), method_23321(), 0, -0F, 0);
		}

		if (!field_6002.field_9236 && liveTime > 200 + delay) {
			method_5650();
		}
	}

	@Override
	protected void method_7488(class_239 pos) {
		class_1297 thrower = method_24921();
		if (pos.method_17783() != class_239.class_240.field_1331 || ((class_3966) pos).method_17782() != thrower) {
			field_6002.method_8437(this, method_23317(), method_23318(), method_23321(), 3F, class_1927.class_4179.field_18685);
			method_5650();
		}
	}

	@Override
	public void method_5652(@Nonnull class_2487 cmp) {
		super.method_5652(cmp);
		cmp.method_10556(TAG_CHARGING, isCharging());
		cmp.method_10569(TAG_VARIETY, getVariety());
		cmp.method_10569(TAG_CHARGE_TICKS, getChargeTicks());
		cmp.method_10569(TAG_LIVE_TICKS, getLiveTicks());
		cmp.method_10569(TAG_DELAY, getDelay());
		cmp.method_10548(TAG_ROTATION, getRotation());
	}

	@Override
	public void method_5749(@Nonnull class_2487 cmp) {
		super.method_5749(cmp);
		setCharging(cmp.method_10577(TAG_CHARGING));
		setVariety(cmp.method_10550(TAG_VARIETY));
		setChargeTicks(cmp.method_10550(TAG_CHARGE_TICKS));
		setLiveTicks(cmp.method_10550(TAG_LIVE_TICKS));
		setDelay(cmp.method_10550(TAG_DELAY));
		setRotation(cmp.method_10583(TAG_ROTATION));
	}

	public boolean isCharging() {
		return field_6011.method_12789(CHARGING);
	}

	public void setCharging(boolean charging) {
		field_6011.method_12778(CHARGING, charging);
	}

	public int getVariety() {
		return field_6011.method_12789(VARIETY);
	}

	public void setVariety(int var) {
		field_6011.method_12778(VARIETY, var);
	}

	public int getChargeTicks() {
		return field_6011.method_12789(CHARGE_TICKS);
	}

	public void setChargeTicks(int ticks) {
		field_6011.method_12778(CHARGE_TICKS, ticks);
	}

	public int getLiveTicks() {
		return field_6011.method_12789(LIVE_TICKS);
	}

	public void setLiveTicks(int ticks) {
		field_6011.method_12778(LIVE_TICKS, ticks);
	}

	public int getDelay() {
		return field_6011.method_12789(DELAY);
	}

	public void setDelay(int delay) {
		field_6011.method_12778(DELAY, delay);
	}

	public float getRotation() {
		return field_6011.method_12789(ROTATION);
	}

	public void setRotation(float rot) {
		field_6011.method_12778(ROTATION, rot);
	}

}
