/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import com.google.gson.JsonObject;
import vazkii.botania.common.block.decor.BlockModMushroom;
import vazkii.botania.common.item.ItemTwigWand;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.material.ItemPetal;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1715;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3955;

public class TwigWandRecipe implements class_3955 {
	public static final class_1865<TwigWandRecipe> SERIALIZER = new Serializer();
	private final class_1869 compose;

	public TwigWandRecipe(class_1869 compose) {
		this.compose = compose;
	}

	@Override
	public boolean matches(@Nonnull class_1715 inv, @Nonnull class_1937 worldIn) {
		return compose.method_17728(inv, worldIn);
	}

	@Nonnull
	@Override
	public class_1799 craft(class_1715 inv) {
		int first = -1;
		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			class_1792 item = stack.method_7909();

			int colorId;
			if (item instanceof ItemPetal) {
				colorId = ((ItemPetal) item).color.method_7789();
			} else if (item instanceof class_1747 && ((class_1747) item).method_7711() instanceof BlockModMushroom) {
				colorId = ((BlockModMushroom) ((class_1747) item).method_7711()).color.method_7789();
			} else {
				continue;
			}
			if (first == -1) {
				first = colorId;
			} else {
				return ItemTwigWand.forColors(first, colorId);
			}
		}
		return ItemTwigWand.forColors(first != -1 ? first : 0, 0);
	}

	@Override
	public boolean method_8113(int width, int height) {
		return compose.method_8113(width, height);
	}

	@Nonnull
	@Override
	public class_1799 method_8110() {
		return new class_1799(ModItems.twigWand);
	}

	@Nonnull
	@Override
	public class_2960 method_8114() {
		return compose.method_8114();
	}

	@Nonnull
	@Override
	public class_2371<class_1799> getRemainingStacks(class_1715 inv) {
		return compose.method_8111(inv);
	}

	@Nonnull
	@Override
	public class_2371<class_1856> method_8117() {
		return compose.method_8117();
	}

	@Nonnull
	@Override
	public String method_8112() {
		return compose.method_8112();
	}

	@Nonnull
	@Override
	public class_1799 method_17447() {
		return compose.method_17447();
	}

	@Nonnull
	@Override
	public class_1865<?> method_8119() {
		return SERIALIZER;
	}

	private static class Serializer implements class_1865<TwigWandRecipe> {
		@Nonnull
		@Override
		public TwigWandRecipe method_8121(@Nonnull class_2960 recipeId, @Nonnull JsonObject json) {
			return new TwigWandRecipe(field_9035.method_8121(recipeId, json));
		}

		@Nullable
		@Override
		public TwigWandRecipe method_8122(@Nonnull class_2960 recipeId, @Nonnull class_2540 buffer) {
			return new TwigWandRecipe(field_9035.method_8122(recipeId, buffer));
		}

		@Override
		public void write(@Nonnull class_2540 buffer, @Nonnull TwigWandRecipe recipe) {
			field_9035.method_8124(buffer, recipe.compose);
		}
	}
}
