/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraPick;

import javax.annotation.Nonnull;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1937;
import net.minecraft.class_2960;

public class TerraPickTippingRecipe extends class_1852 {
	public static final class_1866<TerraPickTippingRecipe> SERIALIZER = new class_1866<>(TerraPickTippingRecipe::new);

	public TerraPickTippingRecipe(class_2960 id) {
		super(id);
	}

	@Nonnull
	@Override
	public class_1865<?> method_8119() {
		return SERIALIZER;
	}

	@Override
	public boolean matches(@Nonnull class_1715 inv, @Nonnull class_1937 world) {
		boolean foundTerraPick = false;
		boolean foundElementiumPick = false;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960()) {
				if (stack.method_7909() instanceof ItemTerraPick && !ItemTerraPick.isTipped(stack)) {
					foundTerraPick = true;
				} else if (stack.method_7909() == ModItems.elementiumPick) {
					foundElementiumPick = true;
				} else {
					return false; // Found an invalid item, breaking the recipe
				}
			}
		}

		return foundTerraPick && foundElementiumPick;
	}

	@Nonnull
	@Override
	public class_1799 craft(@Nonnull class_1715 inv) {
		class_1799 terraPick = class_1799.field_8037;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960() && stack.method_7909() instanceof ItemTerraPick) {
				terraPick = stack;
			}
		}

		if (terraPick.method_7960()) {
			return class_1799.field_8037;
		}

		class_1799 terraPickCopy = terraPick.method_7972();
		ItemTerraPick.setTipped(terraPickCopy);
		return terraPickCopy;
	}

	@Override
	public boolean method_8113(int width, int height) {
		return width * height >= 2;
	}
}
