/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import it.unimi.dsi.fastutil.ints.IntSet;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class RecipeUtils {
	/**
	 * Check if every ingredient in {@code inputs} is satisfied by {@code inv}.
	 * Optionally, the slots from the inventory used to fulfill the inputs are placed into {@code usedSlots}.
	 */
	public static boolean matches(List<class_1856> inputs, class_1263 inv, @Nullable IntSet usedSlots) {
		List<class_1856> ingredientsMissing = new ArrayList<>(inputs);

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 input = inv.method_5438(i);
			if (input.method_7960()) {
				break;
			}

			int stackIndex = -1;

			for (int j = 0; j < ingredientsMissing.size(); j++) {
				class_1856 ingr = ingredientsMissing.get(j);
				if (ingr.method_8093(input)) {
					stackIndex = j;
					if (usedSlots != null) {
						usedSlots.add(i);
					}
					break;
				}
			}

			if (stackIndex != -1) {
				ingredientsMissing.remove(stackIndex);
			} else {
				return false;
			}
		}

		return ingredientsMissing.isEmpty();
	}

	/**
	 * Like the vanilla method on recipe interface, but specialHandler is called first, and if it returns
	 * nonnull, that result is used instead of vanilla's
	 */
	public static class_2371<class_1799> getRemainingItemsSub(class_1263 inv, Function<class_1799, class_1799> specialHandler) {
		class_2371<class_1799> ret = class_2371.method_10213(inv.method_5439(), class_1799.field_8037);

		for (int i = 0; i < ret.size(); ++i) {
			class_1799 item = inv.method_5438(i);
			class_1799 special = specialHandler.apply(item);
			if (special != null) {
				ret.set(i, special);
			} else if (item.method_7909().method_7857()) {
				ret.set(i, new class_1799(item.method_7909().method_7858()));
			}
		}

		return ret;
	}
}
