/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import vazkii.botania.api.item.IPhantomInkable;
import vazkii.botania.common.item.ModItems;

import javax.annotation.Nonnull;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1937;
import net.minecraft.class_2960;

public class PhantomInkRecipe extends class_1852 {
	public static final class_1866<PhantomInkRecipe> SERIALIZER = new class_1866<>(PhantomInkRecipe::new);

	public PhantomInkRecipe(class_2960 id) {
		super(id);
	}

	@Override
	public boolean matches(@Nonnull class_1715 var1, @Nonnull class_1937 var2) {
		boolean foundInk = false;
		boolean foundItem = false;

		for (int i = 0; i < var1.method_5439(); i++) {
			class_1799 stack = var1.method_5438(i);
			if (!stack.method_7960()) {
				if (stack.method_7909() == ModItems.phantomInk && !foundInk) {
					foundInk = true;
				} else if (!foundItem) {
					if (stack.method_7909() instanceof IPhantomInkable && !stack.method_7909().method_7857()) {
						foundItem = true;
					} else {
						return false;
					}
				} else {
					return false;
				}
			}
		}

		return foundInk && foundItem;
	}

	@Nonnull
	@Override
	public class_1799 craft(@Nonnull class_1715 var1) {
		class_1799 item = class_1799.field_8037;

		for (int i = 0; i < var1.method_5439(); i++) {
			class_1799 stack = var1.method_5438(i);
			if (!stack.method_7960() && stack.method_7909() instanceof IPhantomInkable && item.method_7960()) {
				item = stack;
			}
		}

		IPhantomInkable inkable = (IPhantomInkable) item.method_7909();
		class_1799 copy = item.method_7972();
		inkable.setPhantomInk(copy, !inkable.hasPhantomInk(item));
		return copy;
	}

	@Override
	public boolean method_8113(int width, int height) {
		return width * height >= 2;
	}

	@Nonnull
	@Override
	public class_1865<?> method_8119() {
		return SERIALIZER;
	}
}
