/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import com.google.gson.JsonObject;
import vazkii.botania.api.mana.IManaItem;

import javax.annotation.Nonnull;
import net.minecraft.class_1263;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3955;

public class ManaUpgradeRecipe implements class_3955 {
	private final class_1869 compose;

	public ManaUpgradeRecipe(class_1869 compose) {
		this.compose = compose;
	}

	public static class_1799 output(class_1799 output, class_1263 inv) {
		class_1799 out = output.method_7972();
		if (!(out.method_7909() instanceof IManaItem)) {
			return out;
		}
		IManaItem outItem = (IManaItem) out.method_7909();
		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960()) {
				if (stack.method_7909() instanceof IManaItem) {
					IManaItem item = (IManaItem) stack.method_7909();
					outItem.addMana(out, item.getMana(stack));
				}
			}
		}
		return out;
	}

	@Override
	public boolean matches(@Nonnull class_1715 inv, @Nonnull class_1937 world) {
		return compose.method_17728(inv, world);
	}

	@Nonnull
	@Override
	public class_1799 craft(@Nonnull class_1715 inv) {
		return output(compose.method_17727(inv), inv);
	}

	@Nonnull
	@Override
	public class_2371<class_1856> method_8117() {
		return compose.method_8117();
	}

	@Override
	public boolean method_8113(int width, int height) {
		return compose.method_8113(width, height);
	}

	@Nonnull
	@Override
	public class_1799 method_8110() {
		return compose.method_8110();
	}

	@Nonnull
	@Override
	public class_2960 method_8114() {
		return compose.method_8114();
	}

	@Nonnull
	@Override
	public class_1865<?> method_8119() {
		return SERIALIZER;
	}

	public static final class_1865<ManaUpgradeRecipe> SERIALIZER = new Serializer();

	private static class Serializer implements class_1865<ManaUpgradeRecipe> {
		@Override
		public ManaUpgradeRecipe method_8121(@Nonnull class_2960 recipeId, @Nonnull JsonObject json) {
			return new ManaUpgradeRecipe(class_1865.field_9035.method_8121(recipeId, json));
		}

		@Override
		public ManaUpgradeRecipe method_8122(@Nonnull class_2960 recipeId, @Nonnull class_2540 buffer) {
			return new ManaUpgradeRecipe(class_1865.field_9035.method_8122(recipeId, buffer));
		}

		@Override
		public void write(@Nonnull class_2540 buffer, ManaUpgradeRecipe recipe) {
			class_1865.field_9035.method_8124(buffer, recipe.compose);
		}
	};
}
