/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import vazkii.botania.common.item.ItemLaputaShard;
import vazkii.botania.common.item.ModItems;

import javax.annotation.Nonnull;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;

public class LaputaShardUpgradeRecipe extends class_1852 {
	public static final class_1866<LaputaShardUpgradeRecipe> SERIALIZER = new class_1866<>(LaputaShardUpgradeRecipe::new);

	public LaputaShardUpgradeRecipe(class_2960 id) {
		super(id);
	}

	@Override
	public boolean matches(@Nonnull class_1715 inv, @Nonnull class_1937 worldIn) {
		boolean foundShard = false;
		boolean foundSpirit = false;
		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (stack.method_7960()) {
				continue;
			}
			if (stack.method_7909() == ModItems.laputaShard && !foundShard
					&& ItemLaputaShard.getShardLevel(stack) < 19) {
				foundShard = true;
			} else if (stack.method_7909() == ModItems.lifeEssence && !foundSpirit) {
				foundSpirit = true;
			} else {
				return false;
			}
		}
		return foundShard && foundSpirit;
	}

	@Nonnull
	@Override
	public class_1799 method_8110() {
		return new class_1799(ModItems.laputaShard);
	}

	@Nonnull
	@Override
	public class_2371<class_1856> method_8117() {
		return class_2371.method_10212(class_1856.field_9017,
				class_1856.method_8091(ModItems.laputaShard),
				class_1856.method_8091(ModItems.lifeEssence));
	}

	@Nonnull
	@Override
	public class_1799 craft(@Nonnull class_1715 inv) {
		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (stack.method_7909() == ModItems.laputaShard) {
				class_1799 result = stack.method_7972();
				result.method_7948().method_10569(ItemLaputaShard.TAG_LEVEL, ItemLaputaShard.getShardLevel(stack) + 1);
				return result;
			}
		}
		return class_1799.field_8037;
	}

	@Override
	public boolean method_8113(int width, int height) {
		return width * height >= 2;
	}

	@Nonnull
	@Override
	public class_1865<?> method_8119() {
		return SERIALIZER;
	}
}
