/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.RecipeRuneAltar;

import javax.annotation.Nonnull;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import java.util.ArrayList;
import java.util.List;

public class HeadRecipe extends RecipeRuneAltar {

	public HeadRecipe(class_2960 id, class_1799 output, int mana, class_1856... inputs) {
		super(id, output, mana, inputs);
	}

	@Override
	public boolean method_8115(class_1263 inv, @Nonnull class_1937 world) {
		boolean matches = super.method_8115(inv, world);

		if (matches) {
			for (int i = 0; i < inv.method_5439(); i++) {
				class_1799 stack = inv.method_5438(i);
				if (stack.method_7960()) {
					break;
				}

				if (stack.method_7909() == class_1802.field_8448) {
					String defaultName = new class_2588(class_1802.field_8448.method_7876()).getString();
					if (stack.method_7964().getString().equals(defaultName)) {
						return false;
					}
				}
			}
		}

		return matches;
	}

	@Nonnull
	@Override
	public class_1799 method_8116(@Nonnull class_1263 inv) {
		class_1799 stack = method_8110().method_7972();
		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 ingr = inv.method_5438(i);
			if (ingr.method_7909() == class_1802.field_8448) {
				ItemNBTHelper.setString(stack, "SkullOwner", ingr.method_7964().getString());
				break;
			}
		}
		return stack;
	}

	public static class Serializer implements class_1865<HeadRecipe> {

		@Nonnull
		@Override
		public HeadRecipe method_8121(@Nonnull class_2960 id, @Nonnull JsonObject json) {
			class_1799 output = class_1869.method_8155(class_3518.method_15296(json, "output"));
			int mana = class_3518.method_15260(json, "mana");
			JsonArray ingrs = class_3518.method_15261(json, "ingredients");
			List<class_1856> inputs = new ArrayList<>();
			for (JsonElement e : ingrs) {
				inputs.add(class_1856.method_8102(e));
			}
			return new HeadRecipe(id, output, mana, inputs.toArray(new class_1856[0]));
		}

		@Override
		public HeadRecipe method_8122(@Nonnull class_2960 id, @Nonnull class_2540 buf) {
			class_1856[] inputs = new class_1856[buf.method_10816()];
			for (int i = 0; i < inputs.length; i++) {
				inputs[i] = class_1856.method_8086(buf);
			}
			class_1799 output = buf.method_10819();
			int mana = buf.method_10816();
			return new HeadRecipe(id, output, mana, inputs);
		}

		@Override
		public void write(@Nonnull class_2540 buf, @Nonnull HeadRecipe recipe) {
			ModRecipeTypes.RUNE_SERIALIZER.method_8124(buf, recipe);
		}
	}

}
