/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import vazkii.botania.api.item.ICosmeticAttachable;
import vazkii.botania.api.item.ICosmeticBauble;

import javax.annotation.Nonnull;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1937;
import net.minecraft.class_2960;

public class CosmeticAttachRecipe extends class_1852 {
	public static final class_1866<CosmeticAttachRecipe> SERIALIZER = new class_1866<>(CosmeticAttachRecipe::new);

	public CosmeticAttachRecipe(class_2960 id) {
		super(id);
	}

	@Override
	public boolean matches(@Nonnull class_1715 inv, @Nonnull class_1937 world) {
		boolean foundCosmetic = false;
		boolean foundAttachable = false;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960()) {
				if (stack.method_7909() instanceof ICosmeticBauble && !foundCosmetic) {
					foundCosmetic = true;
				} else if (!foundAttachable) {
					if (stack.method_7909() instanceof ICosmeticAttachable && !(stack.method_7909() instanceof ICosmeticBauble) && ((ICosmeticAttachable) stack.method_7909()).getCosmeticItem(stack).method_7960()) {
						foundAttachable = true;
					} else {
						return false;
					}
				}
			}
		}

		return foundCosmetic && foundAttachable;
	}

	@Nonnull
	@Override
	public class_1799 craft(@Nonnull class_1715 inv) {
		class_1799 cosmeticItem = class_1799.field_8037;
		class_1799 attachableItem = class_1799.field_8037;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960()) {
				if (stack.method_7909() instanceof ICosmeticBauble && cosmeticItem.method_7960()) {
					cosmeticItem = stack;
				} else {
					attachableItem = stack;
				}
			}
		}

		if (!(attachableItem.method_7909() instanceof ICosmeticAttachable)) {
			return class_1799.field_8037;
		}

		ICosmeticAttachable attachable = (ICosmeticAttachable) attachableItem.method_7909();
		if (!attachable.getCosmeticItem(attachableItem).method_7960()) {
			return class_1799.field_8037;
		}

		class_1799 copy = attachableItem.method_7972();
		attachable.setCosmeticItem(copy, cosmeticItem);
		return copy;
	}

	@Override
	public boolean method_8113(int width, int height) {
		return width * height >= 2;
	}

	@Nonnull
	@Override
	public class_1865<?> method_8119() {
		return SERIALIZER;
	}
}
