/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import vazkii.botania.api.mana.ICompositableLens;

import javax.annotation.Nonnull;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1937;
import net.minecraft.class_2960;

public class CompositeLensRecipe extends class_1852 {
	public static final class_1866<CompositeLensRecipe> SERIALIZER = new class_1866<>(CompositeLensRecipe::new);

	public CompositeLensRecipe(class_2960 id) {
		super(id);
	}

	@Override
	public boolean matches(@Nonnull class_1715 inv, @Nonnull class_1937 world) {
		boolean foundLens = false;
		boolean foundSecondLens = false;
		boolean foundSlimeball = false;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960()) {
				if (stack.method_7909() instanceof ICompositableLens && !foundSecondLens) {
					if (foundLens) {
						foundSecondLens = true;
					} else {
						foundLens = true;
					}
				} else if (stack.method_7909() == class_1802.field_8777) {
					foundSlimeball = true;
				} else {
					return false; // Found an invalid item, breaking the recipe
				}
			}
		}

		return foundSecondLens && foundSlimeball;
	}

	@Nonnull
	@Override
	public class_1799 craft(@Nonnull class_1715 inv) {
		class_1799 lens = class_1799.field_8037;
		class_1799 secondLens = class_1799.field_8037;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960()) {
				if (stack.method_7909() instanceof ICompositableLens) {
					if (lens.method_7960()) {
						lens = stack;
					} else {
						secondLens = stack;
					}
				}
			}
		}

		if (lens.method_7909() instanceof ICompositableLens) {
			ICompositableLens lensItem = (ICompositableLens) lens.method_7909();
			if (secondLens.method_7960() || !lensItem.canCombineLenses(lens, secondLens) || !lensItem.getCompositeLens(lens).method_7960() || !lensItem.getCompositeLens(secondLens).method_7960()) {
				return class_1799.field_8037;
			}

			class_1799 lensCopy = lens.method_7972();
			lensItem.setCompositeLens(lensCopy, secondLens);

			return lensCopy;
		}

		return class_1799.field_8037;
	}

	@Override
	public boolean method_8113(int width, int height) {
		return width * height >= 3;
	}

	@Nonnull
	@Override
	public class_1865<?> method_8119() {
		return SERIALIZER;
	}
}
