/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import vazkii.botania.api.item.IAncientWillContainer;
import vazkii.botania.common.item.ItemAncientWill;

import javax.annotation.Nonnull;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1937;
import net.minecraft.class_2960;

public class AncientWillRecipe extends class_1852 {
	public static final class_1866<AncientWillRecipe> SERIALIZER = new class_1866<>(AncientWillRecipe::new);

	public AncientWillRecipe(class_2960 id) {
		super(id);
	}

	@Override
	public boolean matches(@Nonnull class_1715 inv, @Nonnull class_1937 world) {
		boolean foundWill = false;
		boolean foundItem = false;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960()) {
				if (stack.method_7909() instanceof ItemAncientWill && !foundWill) {
					foundWill = true;
				} else if (!foundItem) {
					if (stack.method_7909() instanceof IAncientWillContainer) {
						foundItem = true;
					} else {
						return false;
					}
				}
			}
		}

		return foundWill && foundItem;
	}

	@Nonnull
	@Override
	public class_1799 craft(@Nonnull class_1715 inv) {
		class_1799 item = class_1799.field_8037;
		IAncientWillContainer.AncientWillType will = null;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960()) {
				if (stack.method_7909() instanceof IAncientWillContainer && item.method_7960()) {
					item = stack;
				} else {
					will = ((ItemAncientWill) stack.method_7909()).type; // we already verified this is a will in matches()
				}
			}
		}

		IAncientWillContainer container = (IAncientWillContainer) item.method_7909();
		if (container.hasAncientWill(item, will)) {
			return class_1799.field_8037;
		}

		class_1799 copy = item.method_7972();
		container.addAncientWill(copy, will);
		return copy;
	}

	@Override
	public boolean method_8113(int width, int height) {
		return width > 1 || height > 1;
	}

	@Nonnull
	@Override
	public class_1865<?> method_8119() {
		return SERIALIZER;
	}
}
