/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JsonOps;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.core.helper.ItemNBTHelper;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_3518;

public class StateIngredientHelper {
	public static StateIngredient of(class_2248 block) {
		return new StateIngredientBlock(block);
	}

	public static StateIngredient of(class_2680 state) {
		return new StateIngredientBlockState(state);
	}

	public static StateIngredient of(class_3494.class_5123<class_2248> tag) {
		return of(tag.method_26791());
	}

	public static StateIngredient of(class_2960 id) {
		return new StateIngredientTag(id);
	}

	public static StateIngredient of(Set<class_2248> blocks) {
		return new StateIngredientBlocks(blocks);
	}

	public static StateIngredient deserialize(JsonObject object) {
		switch (class_3518.method_15265(object, "type")) {
		case "tag":
			return new StateIngredientTag(new class_2960(class_3518.method_15265(object, "tag")));
		case "block":
			return new StateIngredientBlock(class_2378.field_11146.method_10223(new class_2960(class_3518.method_15265(object, "block"))));
		case "state":
			return new StateIngredientBlockState(readBlockState(object));
		case "blocks":
			HashSet<class_2248> blocks = new HashSet<>();
			for (JsonElement element : class_3518.method_15261(object, "blocks")) {
				blocks.add(class_2378.field_11146.method_10223(new class_2960(element.getAsString())));
			}
			return new StateIngredientBlocks(blocks);
		default:
			throw new JsonParseException("Unknown type!");
		}
	}

	public static StateIngredient read(class_2540 buffer) {
		switch (buffer.method_10816()) {
		case 0:
			int count = buffer.method_10816();
			Set<class_2248> set = new HashSet<>();
			for (int i = 0; i < count; i++) {
				int id = buffer.method_10816();
				class_2248 block = class_2378.field_11146.method_10200(id);
				set.add(block);
			}
			return new StateIngredientBlocks(set);
		case 1:
			return new StateIngredientBlock(class_2378.field_11146.method_10200(buffer.method_10816()));
		case 2:
			return new StateIngredientBlockState(class_2248.method_9531(buffer.method_10816()));
		default:
			throw new IllegalArgumentException("Unknown input discriminator!");
		}
	}

	/**
	 * Writes data about the block state to the provided json object.
	 */
	public static JsonObject serializeBlockState(class_2680 state) {
		class_2487 nbt = class_2512.method_10686(state);
		ItemNBTHelper.renameTag(nbt, "Name", "name");
		ItemNBTHelper.renameTag(nbt, "Properties", "properties");
		Dynamic<net.minecraft.class_2520> dyn = new Dynamic<>(class_2509.field_11560, nbt);
		return dyn.convert(JsonOps.INSTANCE).getValue().getAsJsonObject();
	}

	/**
	 * Reads the block state from the provided json object.
	 */
	public static class_2680 readBlockState(JsonObject object) {
		class_2487 nbt = (class_2487) new Dynamic<>(JsonOps.INSTANCE, object).convert(class_2509.field_11560).getValue();
		ItemNBTHelper.renameTag(nbt, "name", "Name");
		ItemNBTHelper.renameTag(nbt, "properties", "Properties");
		String name = nbt.method_10558("Name");
		class_2960 id = class_2960.method_12829(name);
		if (id == null || !class_2378.field_11146.method_17966(id).isPresent()) {
			throw new IllegalArgumentException("Invalid or unknown block ID: " + name);
		}
		return class_2512.method_10681(nbt);
	}
}
