/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import vazkii.botania.api.recipe.StateIngredient;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2680;

public class StateIngredientBlocks implements StateIngredient {
	private final Set<class_2248> blocks;

	public StateIngredientBlocks(Collection<class_2248> blocks) {
		this.blocks = ImmutableSet.copyOf(blocks);
	}

	@Override
	public boolean test(class_2680 state) {
		return blocks.contains(state.method_26204());
	}

	@Override
	public JsonObject serialize() {
		JsonObject object = new JsonObject();
		object.addProperty("type", "blocks");
		JsonArray array = new JsonArray();
		for (class_2248 block : blocks) {
			array.add(class_2378.field_11146.method_10221(block).toString());
		}
		object.add("blocks", array);
		return object;
	}

	@Override
	public void write(class_2540 buffer) {
		buffer.method_10804(0);
		Collection<class_2248> blocks = getBlocks();
		buffer.method_10804(blocks.size());
		for (class_2248 block : blocks) {
			buffer.method_10804(class_2378.field_11146.method_10206(block));
		}
	}

	@Override
	public List<class_2680> getDisplayed() {
		return blocks.stream().map(class_2248::method_9564).collect(Collectors.toList());
	}

	protected Collection<class_2248> getBlocks() {
		return blocks;
	}
}
