/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonObject;
import vazkii.botania.api.recipe.StateIngredient;

import java.util.Collections;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2680;

public class StateIngredientBlockState implements StateIngredient {
	private final class_2680 state;

	public StateIngredientBlockState(class_2680 state) {
		this.state = state;
	}

	@Override
	public boolean test(class_2680 blockState) {
		return this.state == blockState;
	}

	@Override
	public JsonObject serialize() {
		JsonObject object = StateIngredientHelper.serializeBlockState(state);
		object.addProperty("type", "state");
		return object;
	}

	@Override
	public void write(class_2540 buffer) {
		buffer.method_10804(2);
		buffer.method_10804(class_2248.method_9507(state));
	}

	@Override
	public List<class_2680> getDisplayed() {
		return Collections.singletonList(state);
	}

}
