/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonObject;
import vazkii.botania.api.recipe.StateIngredient;

import java.util.Collections;
import java.util.List;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2680;

public class StateIngredientBlock implements StateIngredient {
	private final net.minecraft.class_2248 block;

	public StateIngredientBlock(net.minecraft.class_2248 block) {
		this.block = block;
	}

	@Override
	public boolean test(class_2680 blockState) {
		return block == blockState.method_26204();
	}

	@Override
	public JsonObject serialize() {
		JsonObject object = new JsonObject();
		object.addProperty("type", "block");
		object.addProperty("block", class_2378.field_11146.method_10221(block).toString());
		return object;
	}

	@Override
	public void write(class_2540 buffer) {
		buffer.method_10804(1);
		buffer.method_10804(class_2378.field_11146.method_10206(block));
	}

	@Override
	public List<class_2680> getDisplayed() {
		return Collections.singletonList(block.method_9564());
	}

}
