/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import vazkii.botania.api.recipe.IPureDaisyRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.api.subtile.TileEntitySpecialFlower;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class RecipePureDaisy implements IPureDaisyRecipe {

	public static final int DEFAULT_TIME = 150;

	private final class_2960 id;
	private final StateIngredient input;
	private final class_2680 outputState;
	private final int time;

	/**
	 * @param id    The ID for this recipe.
	 * @param input The input for the recipe. Can be a Block, BlockState, or Tag&lt;Block&gt;.
	 * @param state The blockstate to be placed upon recipe completion.
	 * @param time  The amount of time in ticks to complete this recipe. Note that this is ticks on your block, not
	 *              total time.
	 *              The Pure Daisy only ticks one block at a time in a round robin fashion.
	 */
	public RecipePureDaisy(class_2960 id, StateIngredient input, class_2680 state, int time) {
		Preconditions.checkArgument(time >= 0, "Time must be nonnegative");
		this.id = id;
		this.input = input;
		this.outputState = state;
		this.time = time;
	}

	@Override
	public boolean matches(class_1937 world, class_2338 pos, TileEntitySpecialFlower pureDaisy, class_2680 state) {
		return input.test(state);
	}

	@Override
	public boolean set(class_1937 world, class_2338 pos, TileEntitySpecialFlower pureDaisy) {
		if (!world.field_9236) {
			world.method_8501(pos, outputState);
		}
		return true;
	}

	@Override
	public StateIngredient getInput() {
		return input;
	}

	@Override
	public class_2680 getOutputState() {
		return outputState;
	}

	@Override
	public int getTime() {
		return time;
	}

	@Override
	public class_2960 method_8114() {
		return id;
	}

	@Override
	public class_1865<?> method_8119() {
		return ModRecipeTypes.PURE_DAISY_SERIALIZER;
	}

	public static class Serializer implements class_1865<RecipePureDaisy> {
		@Nonnull
		@Override
		public RecipePureDaisy method_8121(@Nonnull class_2960 id, JsonObject object) {
			StateIngredient input = StateIngredientHelper.deserialize(class_3518.method_15296(object, "input"));
			class_2680 output = StateIngredientHelper.readBlockState(class_3518.method_15296(object, "output"));
			int time = class_3518.method_15282(object, "time", DEFAULT_TIME);
			return new RecipePureDaisy(id, input, output, time);
		}

		@Override
		public void write(@Nonnull class_2540 buf, RecipePureDaisy recipe) {
			recipe.input.write(buf);
			buf.method_10804(class_2248.method_9507(recipe.outputState));
			buf.method_10804(recipe.time);
		}

		@Nullable
		@Override
		public RecipePureDaisy method_8122(@Nonnull class_2960 id, @Nonnull class_2540 buf) {
			StateIngredient input = StateIngredientHelper.read(buf);
			class_2680 output = class_2248.method_9531(buf.method_10816());
			int time = buf.method_10816();
			return new RecipePureDaisy(id, input, output, time);
		}
	}
}
