/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import vazkii.botania.api.recipe.IPetalRecipe;
import vazkii.botania.common.block.ModBlocks;

import javax.annotation.Nonnull;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import java.util.ArrayList;
import java.util.List;

public class RecipePetals implements IPetalRecipe {
	private final class_2960 id;
	private final class_1799 output;
	private final class_2371<class_1856> inputs;

	public RecipePetals(class_2960 id, class_1799 output, class_1856... inputs) {
		this.id = id;
		this.output = output;
		this.inputs = class_2371.method_10212(class_1856.field_9017, inputs);
	}

	@Override
	public boolean method_8115(class_1263 inv, @Nonnull class_1937 world) {
		List<class_1856> ingredientsMissing = new ArrayList<>(inputs);

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 input = inv.method_5438(i);
			if (input.method_7960()) {
				break;
			}

			int stackIndex = -1;

			for (int j = 0; j < ingredientsMissing.size(); j++) {
				class_1856 ingr = ingredientsMissing.get(j);
				if (ingr.method_8093(input)) {
					stackIndex = j;
					break;
				}
			}

			if (stackIndex != -1) {
				ingredientsMissing.remove(stackIndex);
			} else {
				return false;
			}
		}

		return ingredientsMissing.isEmpty();
	}

	@Nonnull
	@Override
	public final class_1799 method_8110() {
		return output;
	}

	@Nonnull
	@Override
	public class_1799 method_8116(@Nonnull class_1263 inv) {
		return method_8110().method_7972();
	}

	@Nonnull
	@Override
	public class_2371<class_1856> method_8117() {
		return inputs;
	}

	@Nonnull
	@Override
	public class_1799 method_17447() {
		return new class_1799(ModBlocks.defaultAltar);
	}

	@Nonnull
	@Override
	public class_2960 method_8114() {
		return id;
	}

	@Nonnull
	@Override
	public class_1865<?> method_8119() {
		return ModRecipeTypes.PETAL_SERIALIZER;
	}

	public static class Serializer implements class_1865<RecipePetals> {
		@Nonnull
		@Override
		public RecipePetals method_8121(@Nonnull class_2960 id, @Nonnull JsonObject json) {
			class_1799 output = class_1869.method_8155(class_3518.method_15296(json, "output"));
			JsonArray ingrs = class_3518.method_15261(json, "ingredients");
			List<class_1856> inputs = new ArrayList<>();
			for (JsonElement e : ingrs) {
				inputs.add(class_1856.method_8102(e));
			}
			return new RecipePetals(id, output, inputs.toArray(new class_1856[0]));
		}

		@Override
		public RecipePetals method_8122(@Nonnull class_2960 id, @Nonnull class_2540 buf) {
			class_1856[] inputs = new class_1856[buf.method_10816()];
			for (int i = 0; i < inputs.length; i++) {
				inputs[i] = class_1856.method_8086(buf);
			}
			class_1799 output = buf.method_10819();
			return new RecipePetals(id, output, inputs);
		}

		@Override
		public void write(@Nonnull class_2540 buf, @Nonnull RecipePetals recipe) {
			buf.method_10804(recipe.method_8117().size());
			for (class_1856 input : recipe.method_8117()) {
				input.method_8088(buf);
			}
			buf.method_10793(recipe.method_8110());
		}

	}

}
