/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import vazkii.botania.api.recipe.IManaInfusionRecipe;
import vazkii.botania.common.block.ModBlocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import java.util.Objects;
import java.util.Optional;

public class RecipeManaInfusion implements IManaInfusionRecipe {
	private final class_2960 id;
	private final class_1799 output;
	private final class_1856 input;
	private final int mana;
	@Nullable
	private final class_2680 catalystState;
	private final String group;

	public RecipeManaInfusion(class_2960 id, class_1799 output, class_1856 input, int mana,
			@Nullable String group, @Nullable class_2680 catalystState) {
		this.id = id;
		this.output = output;
		this.input = input;
		this.mana = mana;
		Preconditions.checkArgument(mana < 100000);
		this.group = group == null ? "" : group;
		this.catalystState = catalystState;
	}

	@Nonnull
	@Override
	public final class_2960 method_8114() {
		return id;
	}

	@Nonnull
	@Override
	public class_1865<RecipeManaInfusion> method_8119() {
		return ModRecipeTypes.MANA_INFUSION_SERIALIZER;
	}

	@Override
	public boolean matches(class_1799 stack) {
		return input.method_8093(stack);
	}

	@Nullable
	@Override
	public class_2680 getCatalyst() {
		return catalystState;
	}

	@Override
	public int getManaToConsume() {
		return mana;
	}

	@Nonnull
	@Override
	public class_1799 method_8110() {
		return output;
	}

	@Nonnull
	@Override
	public class_2371<class_1856> method_8117() {
		return class_2371.method_10212(class_1856.field_9017, input);
	}

	@Nonnull
	@Override
	public String method_8112() {
		return group;
	}

	@Nonnull
	@Override
	public class_1799 method_17447() {
		return new class_1799(ModBlocks.manaPool);
	}

	public static class Serializer implements class_1865<RecipeManaInfusion> {

		@Nonnull
		@Override
		public RecipeManaInfusion method_8121(@Nonnull class_2960 id, @Nonnull JsonObject json) {
			JsonElement input = Objects.requireNonNull(json.get("input"));
			class_1856 ing = class_1856.method_8102(input);
			class_1799 output = class_1869.method_8155(class_3518.method_15296(json, "output"));
			int mana = class_3518.method_15260(json, "mana");
			String group = class_3518.method_15253(json, "group", "");
			class_2680 catalystState = null;
			if (json.has("catalyst")) {
				if (json.get("catalyst").isJsonPrimitive()) {
					String s = class_3518.method_15265(json, "catalyst");
					class_2960 catalystId = class_2960.method_12829(s);
					if (catalystId == null) {
						throw new IllegalArgumentException("Invalid catalyst ID: " + s);
					}
					Optional<class_2248> cat = class_2378.field_11146.method_17966(catalystId);
					if (!cat.isPresent()) {
						throw new IllegalArgumentException("Unknown catalyst: " + s);
					}
					catalystState = cat.get().method_9564();
				} else {
					catalystState = StateIngredientHelper.readBlockState(class_3518.method_15296(json, "catalyst"));
				}
			}

			RecipeManaInfusion ret = new RecipeManaInfusion(id, output, ing, mana, group, catalystState);
			return ret;
		}

		@Nullable
		@Override
		public RecipeManaInfusion method_8122(@Nonnull class_2960 id, @Nonnull class_2540 buf) {
			class_1856 input = class_1856.method_8086(buf);
			class_1799 output = buf.method_10819();
			int mana = buf.method_10816();
			int catalystId = buf.readInt();
			String group = buf.method_19772();
			class_2680 catalystState = catalystId == -1 ? null : class_2248.method_9531(catalystId);
			return new RecipeManaInfusion(id, output, input, mana, group, catalystState);
		}

		@Override
		public void write(@Nonnull class_2540 buf, @Nonnull RecipeManaInfusion recipe) {
			recipe.method_8117().get(0).method_8088(buf);
			buf.method_10793(recipe.method_8110());
			buf.method_10804(recipe.getManaToConsume());
			buf.writeInt(recipe.getCatalyst() == null ? -1 : class_2248.method_9507(recipe.getCatalyst()));
			buf.method_10814(recipe.method_8112());
		}
	}
}
