/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.IBrewContainer;
import vazkii.botania.api.recipe.IBrewRecipe;
import vazkii.botania.common.block.ModBlocks;

import javax.annotation.Nonnull;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RecipeBrew implements IBrewRecipe {
	private final class_2960 id;
	private final Brew brew;
	private final class_2371<class_1856> inputs;

	public RecipeBrew(class_2960 id, Brew brew, class_1856... inputs) {
		this.id = id;
		this.brew = brew;
		this.inputs = class_2371.method_10212(class_1856.field_9017, inputs);
	}

	@Override
	public boolean method_8115(class_1263 inv, @Nonnull class_1937 world) {
		List<class_1856> inputsMissing = new ArrayList<>(inputs);

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (stack.method_7960()) {
				break;
			}

			if (stack.method_7909() instanceof IBrewContainer) {
				continue;
			}

			boolean matchedOne = false;

			Iterator<class_1856> iter = inputsMissing.iterator();
			while (iter.hasNext()) {
				class_1856 input = iter.next();
				if (input.method_8093(stack)) {
					iter.remove();
					matchedOne = true;
					break;
				}
			}

			if (!matchedOne) {
				return false;
			}
		}

		return inputsMissing.isEmpty();
	}

	@Nonnull
	@Override
	public class_2371<class_1856> method_8117() {
		return inputs;
	}

	@Nonnull
	@Override
	public class_1799 method_17447() {
		return new class_1799(ModBlocks.brewery);
	}

	@Nonnull
	@Override
	public class_2960 method_8114() {
		return id;
	}

	@Nonnull
	@Override
	public class_1865<?> method_8119() {
		return ModRecipeTypes.BREW_SERIALIZER;
	}

	@Override
	public Brew getBrew() {
		return brew;
	}

	@Override
	public int getManaUsage() {
		return brew.getManaCost();
	}

	@Override
	public class_1799 getOutput(class_1799 stack) {
		if (stack.method_7960() || !(stack.method_7909() instanceof IBrewContainer)) {
			return new class_1799(class_1802.field_8469); // Fallback...
		}
		IBrewContainer container = (IBrewContainer) stack.method_7909();

		return container.getItemForBrew(brew, stack);
	}

	@Override
	public int hashCode() {
		return 31 * brew.hashCode() ^ inputs.hashCode();
	}

	@Override
	public boolean equals(Object o) {
		return o instanceof RecipeBrew
				&& brew == ((RecipeBrew) o).brew
				&& inputs.equals(((RecipeBrew) o).inputs);
	}

	public static class Serializer implements class_1865<RecipeBrew> {
		@Nonnull
		@Override
		public RecipeBrew method_8121(@Nonnull class_2960 id, @Nonnull JsonObject json) {
			String brewStr = class_3518.method_15265(json, "brew");
			class_2960 brewId = class_2960.method_12829(brewStr);
			if (brewId == null || !BotaniaAPI.instance().getBrewRegistry().method_17966(brewId).isPresent()) {
				throw new JsonParseException("Unknown brew " + brewStr);
			}
			Brew brew = BotaniaAPI.instance().getBrewRegistry().method_10223(brewId);

			JsonArray ingrs = class_3518.method_15261(json, "ingredients");
			List<class_1856> inputs = new ArrayList<>();
			for (JsonElement e : ingrs) {
				inputs.add(class_1856.method_8102(e));
			}
			return new RecipeBrew(id, brew, inputs.toArray(new class_1856[0]));
		}

		@Override
		public RecipeBrew method_8122(@Nonnull class_2960 id, @Nonnull class_2540 buf) {
			int intId = buf.method_10816();
			Brew brew = BotaniaAPI.instance().getBrewRegistry().method_10200(intId);
			class_1856[] inputs = new class_1856[buf.method_10816()];
			for (int i = 0; i < inputs.length; i++) {
				inputs[i] = class_1856.method_8086(buf);
			}
			return new RecipeBrew(id, brew, inputs);
		}

		@Override
		public void write(@Nonnull class_2540 buf, @Nonnull RecipeBrew recipe) {
			int intId = BotaniaAPI.instance().getBrewRegistry().method_10206(recipe.getBrew());
			buf.method_10804(intId);
			buf.method_10804(recipe.method_8117().size());
			for (class_1856 input : recipe.method_8117()) {
				input.method_8088(buf);
			}
		}
	}
}
