/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting;

import vazkii.botania.api.recipe.*;
import vazkii.botania.common.crafting.recipe.HeadRecipe;
import vazkii.botania.mixin.AccessorRecipeManager;

import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

import static vazkii.botania.common.block.ModBlocks.register;
import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class ModRecipeTypes {
	public static final net.minecraft.class_3956<IManaInfusionRecipe> MANA_INFUSION_TYPE = new RecipeType<>();
	public static final class_1865<RecipeManaInfusion> MANA_INFUSION_SERIALIZER = new RecipeManaInfusion.Serializer();

	public static final net.minecraft.class_3956<IElvenTradeRecipe> ELVEN_TRADE_TYPE = new RecipeType<>();
	public static final class_1865<RecipeElvenTrade> ELVEN_TRADE_SERIALIZER = new RecipeElvenTrade.Serializer();
	public static final class_1866<LexiconElvenTradeRecipe> LEXICON_ELVEN_TRADE_SERIALIZER = new class_1866<>(LexiconElvenTradeRecipe::new);

	public static final net.minecraft.class_3956<IPureDaisyRecipe> PURE_DAISY_TYPE = new RecipeType<>();
	public static final class_1865<RecipePureDaisy> PURE_DAISY_SERIALIZER = new RecipePureDaisy.Serializer();

	public static final net.minecraft.class_3956<IBrewRecipe> BREW_TYPE = new RecipeType<>();
	public static final class_1865<RecipeBrew> BREW_SERIALIZER = new RecipeBrew.Serializer();

	public static final net.minecraft.class_3956<IPetalRecipe> PETAL_TYPE = new RecipeType<>();
	public static final class_1865<RecipePetals> PETAL_SERIALIZER = new RecipePetals.Serializer();

	public static final net.minecraft.class_3956<IRuneAltarRecipe> RUNE_TYPE = new RecipeType<>();
	public static final class_1865<RecipeRuneAltar> RUNE_SERIALIZER = new RecipeRuneAltar.Serializer();
	public static final class_1865<HeadRecipe> RUNE_HEAD_SERIALIZER = new HeadRecipe.Serializer();

	public static final RecipeType<ITerraPlateRecipe> TERRA_PLATE_TYPE = new RecipeType<>();
	public static final class_1865<RecipeTerraPlate> TERRA_PLATE_SERIALIZER = new RecipeTerraPlate.Serializer();

	public static void registerRecipeTypes() {
		class_2960 id = prefix("elven_trade");
		class_2378.method_10230(class_2378.field_17597, id, ELVEN_TRADE_TYPE);
		class_2378<class_1865<?>> r = class_2378.field_17598;
		register(r, id, ELVEN_TRADE_SERIALIZER);
		register(r, prefix("elven_trade_lexicon"), LEXICON_ELVEN_TRADE_SERIALIZER);

		id = prefix("mana_infusion");
		class_2378.method_10230(class_2378.field_17597, id, MANA_INFUSION_TYPE);
		register(r, id, MANA_INFUSION_SERIALIZER);

		id = prefix("pure_daisy");
		class_2378.method_10230(class_2378.field_17597, id, PURE_DAISY_TYPE);
		register(r, id, PURE_DAISY_SERIALIZER);

		id = prefix("brew");
		class_2378.method_10230(class_2378.field_17597, id, BREW_TYPE);
		register(r, id, BREW_SERIALIZER);

		id = prefix("petal_apothecary");
		class_2378.method_10230(class_2378.field_17597, id, PETAL_TYPE);
		register(r, id, PETAL_SERIALIZER);

		id = prefix("runic_altar");
		class_2378.method_10230(class_2378.field_17597, id, RUNE_TYPE);
		register(r, id, RUNE_SERIALIZER);
		register(r, prefix("runic_altar_head"), RUNE_HEAD_SERIALIZER);

		id = prefix("terra_plate");
		class_2378.method_10230(class_2378.field_17597, id, TERRA_PLATE_TYPE);
		register(r, id, TERRA_PLATE_SERIALIZER);
	}

	private static class RecipeType<T extends class_1860<?>> implements net.minecraft.class_3956<T> {
		@Override
		public String toString() {
			return class_2378.field_17597.method_10221(this).toString();
		}
	}

	public static <C extends class_1263, T extends class_1860<C>> Map<class_2960, class_1860<C>> getRecipes(class_1937 world, net.minecraft.class_3956<T> type) {
		return ((AccessorRecipeManager) world.method_8433()).botania_getAll(type);
	}
}
