/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting;

import vazkii.botania.api.recipe.IElvenTradeRecipe;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ItemLexicon;
import vazkii.botania.common.item.ModItems;

import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class LexiconElvenTradeRecipe implements IElvenTradeRecipe {
	private final class_2960 id;

	LexiconElvenTradeRecipe(class_2960 id) {
		this.id = id;
	}

	@Override
	public boolean containsItem(class_1799 stack) {
		return stack.method_7909() == ModItems.lexicon && !ItemNBTHelper.getBoolean(stack, ItemLexicon.TAG_ELVEN_UNLOCK, false);
	}

	@Nonnull
	@Override
	public class_2371<class_1856> method_8117() {
		return class_2371.method_10213(1, class_1856.method_8091(ModItems.lexicon));
	}

	@Nonnull
	@Override
	public class_1799 method_17447() {
		return new class_1799(ModBlocks.alfPortal);
	}

	@Nonnull
	@Override
	public class_2960 method_8114() {
		return id;
	}

	@Override
	public List<class_1799> getOutputs() {
		class_1799 stack = new class_1799(ModItems.lexicon);
		stack.method_7948().method_10556(ItemLexicon.TAG_ELVEN_UNLOCK, true);
		return Collections.singletonList(stack);
	}

	@Override
	public Optional<List<class_1799>> match(List<class_1799> stacks) {
		if (stacks.size() == 1 && stacks.get(0).method_7909() == ModItems.lexicon && !ItemNBTHelper.getBoolean(stacks.get(0), ItemLexicon.TAG_ELVEN_UNLOCK, false)) {
			return Optional.of(new ArrayList<>(stacks));
		}
		return Optional.empty();
	}

	@Override
	public List<class_1799> getOutputs(List<class_1799> inputs) {
		class_1799 stack = inputs.get(0).method_7972();
		stack.method_7948().method_10556(ItemLexicon.TAG_ELVEN_UNLOCK, true);
		return Collections.singletonList(stack);
	}

	@Nonnull
	@Override
	public class_1865<LexiconElvenTradeRecipe> method_8119() {
		return ModRecipeTypes.LEXICON_ELVEN_TRADE_SERIALIZER;
	}
}
