/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.core.loot;

import net.fabricmc.fabric.api.loot.v1.FabricLootSupplierBuilder;
import net.fabricmc.fabric.api.loot.v1.event.LootTableLoadingCallback;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_55;
import net.minecraft.class_60;
import net.minecraft.class_79;
import net.minecraft.class_83;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public final class LootHandler {

	public static void lootLoad(class_3300 resourceManager, class_60 manager, class_2960 id, FabricLootSupplierBuilder supplier, LootTableLoadingCallback.LootTableSetter setter) {
		String prefix = "minecraft:chests/";
		String name = id.toString();

		if (name.startsWith(prefix)) {
			String file = name.substring(name.indexOf(prefix) + prefix.length());
			switch (file) {
			case "abandoned_mineshaft":
			case "desert_pyramid":
			case "jungle_temple":
			case "simple_dungeon":
			case "spawn_bonus_chest":
			case "stronghold_corridor":
			case "village_blacksmith":
				supplier.withPool(getInjectPool(file));
				break;
			default:
				break;
			}
		}
	}

	public static class_55 getInjectPool(String entryName) {
		return class_55.method_347()
				.method_351(getInjectEntry(entryName, 1))
				// todo 1.16-fabric .bonusRolls(0, 1)
				.method_355();
	}

	private static class_79.class_80<?> getInjectEntry(String name, int weight) {
		class_2960 table = prefix("inject/" + name);
		return class_83.method_428(table)
				.method_437(weight);
	}

}
