/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.core.helper;

import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.mixin.AccessorHopperBlockEntity;

import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2614;

public class InventoryHelper {

	// [VanillaCopy] HopperBlockEntity#transfer but simulates instead of doing it
	public static class_1799 simulateTransfer(class_1263 to, class_1799 stack, class_2350 side) {
		stack = stack.method_7972();

		if (to instanceof class_1278 && side != null) {
			class_1278 sidedInventory = (class_1278) to;
			int[] is = sidedInventory.method_5494(side);

			for (int i = 0; i < is.length && !stack.method_7960(); ++i) {
				stack = simulateTransfer(to, stack, is[i], side);
			}
		} else {
			int j = to.method_5439();

			for (int k = 0; k < j && !stack.method_7960(); ++k) {
				stack = simulateTransfer(to, stack, k, side);
			}
		}

		return stack;
	}

	// [VanillaCopy] HopperBlockEntity without modifying the destination inventory. `stack` is still modified
	private static class_1799 simulateTransfer(class_1263 to, class_1799 stack, int slot, class_2350 direction) {
		class_1799 itemStack = to.method_5438(slot);
		if (AccessorHopperBlockEntity.botania_canInsert(to, stack, slot, direction)) {
			boolean bl = false;
			boolean bl2 = to.method_5442();
			if (itemStack.method_7960()) {
				// to.setStack(slot, stack);
				stack = class_1799.field_8037;
				bl = true;
			} else if (AccessorHopperBlockEntity.botania_canMerge(itemStack, stack)) {
				int i = stack.method_7914() - itemStack.method_7947();
				int j = Math.min(stack.method_7947(), i);
				stack.method_7934(j);
				// itemStack.increment(j);
				bl = j > 0;
			}

			/*
			if (bl) {
				if (bl2 && to instanceof HopperBlockEntity) {
					HopperBlockEntity hopperBlockEntity = (HopperBlockEntity)to;
					if (!hopperBlockEntity.isDisabled()) {
						int k = 0;
						if (from instanceof HopperBlockEntity) {
							HopperBlockEntity hopperBlockEntity2 = (HopperBlockEntity)from;
							if (hopperBlockEntity.lastTickTime >= hopperBlockEntity2.lastTickTime) {
								k = 1;
							}
						}
			
						hopperBlockEntity.setCooldown(8 - k);
					}
				}
			
				to.markDirty();
			}
			*/
		}

		return stack;
	}

	@Nullable
	public static class_1263 getInventory(class_1937 world, class_2338 pos, class_2350 side) {
		class_1263 ret = class_2614.method_11250(world, pos);
		if (ret instanceof class_1297) {
			return null;
		}
		return ret;
	}

	public static void withdrawFromInventory(TileSimpleInventory inv, class_1657 player) {
		for (int i = inv.inventorySize() - 1; i >= 0; i--) {
			class_1799 stackAt = inv.getItemHandler().method_5438(i);
			if (!stackAt.method_7960()) {
				class_1799 copy = stackAt.method_7972();
				player.field_7514.method_7398(player.field_6002, copy);
				inv.getItemHandler().method_5447(i, class_1799.field_8037);
				break;
			}
		}
	}

}
