/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.core.handler;

import vazkii.botania.common.entity.EntityDoppleganger;
import vazkii.botania.common.entity.ModEntities;

import javax.annotation.Nullable;
import net.minecraft.class_1301;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3218;

public final class SleepingHandler {

	private SleepingHandler() {}

	@Nullable
	public static class_1657.class_1658 trySleep(class_1657 player) {
		class_1937 world = player.field_6002;
		if (!world.method_8608()) {
			boolean nearGuardian = ((class_3218) world).method_18198(ModEntities.DOPPLEGANGER, class_1301.field_6154)
					.stream()
					.anyMatch(e -> ((EntityDoppleganger) e).getPlayersAround().contains(player));

			if (nearGuardian) {
				return class_1657.class_1658.field_7532;
			}
		}
		return null;
	}
}
