/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.core.handler;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;

public final class ModSounds {
	public static final class_3414 airRod = makeSoundEvent("air_rod");
	public static final class_3414 agricarnation = makeSoundEvent("agricarnation");
	public static final class_3414 altarCraft = makeSoundEvent("altar_craft");
	public static final class_3414 arcaneRoseDisenchant = makeSoundEvent("arcane_rose_disenchant");
	public static final class_3414 babylonAttack = makeSoundEvent("babylon_attack");
	public static final class_3414 babylonSpawn = makeSoundEvent("babylon_spawn");
	public static final class_3414 bellows = makeSoundEvent("bellows");
	public static final class_3414 bifrostRod = makeSoundEvent("bifrost_rod");
	public static final class_3414 blackLotus = makeSoundEvent("black_lotus");
	public static final class_3414 dash = makeSoundEvent("dash");
	public static final class_3414 ding = makeSoundEvent("ding");
	public static final class_3414 divaCharm = makeSoundEvent("diva_charm");
	public static final class_3414 divinationRod = makeSoundEvent("divination_rod");
	public static final class_3414 doit = makeSoundEvent("doit");
	public static final class_3414 enchanterFade = makeSoundEvent("enchanter_fade");
	public static final class_3414 enchanterForm = makeSoundEvent("enchanter_form");
	public static final class_3414 enchanterEnchant = makeSoundEvent("enchanter_enchant");
	public static final class_3414 endoflame = makeSoundEvent("endoflame");
	public static final class_3414 equipBauble = makeSoundEvent("equip_bauble");
	public static final class_3414 gaiaTrap = makeSoundEvent("gaia_trap");
	public static final class_3414 holyCloak = makeSoundEvent("holy_cloak");
	public static final class_3414 laputaStart = makeSoundEvent("laputa_start");
	public static final class_3414 lexiconOpen = makeSoundEvent("lexicon_open");
	public static final class_3414 lexiconPage = makeSoundEvent("lexicon_page");
	public static final class_3414 lightRelay = makeSoundEvent("light_relay");
	public static final class_3414 manaBlaster = makeSoundEvent("mana_blaster");
	public static final class_3414 manaPoolCraft = makeSoundEvent("mana_pool_craft");
	public static final class_3414 missile = makeSoundEvent("missile");
	public static final class_3414 orechid = makeSoundEvent("orechid");
	public static final class_3414 potionCreate = makeSoundEvent("potion_create");
	public static final class_3414 runeAltarCraft = makeSoundEvent("rune_altar_craft");
	public static final class_3414 runeAltarStart = makeSoundEvent("rune_altar_start");
	public static final class_3414 spreaderFire = makeSoundEvent("spreader_fire");
	public static final class_3414 starcaller = makeSoundEvent("starcaller");
	public static final class_3414 terraBlade = makeSoundEvent("terrablade");
	public static final class_3414 terraformRod = makeSoundEvent("terraform_rod");
	public static final class_3414 terraPickMode = makeSoundEvent("terra_pick_mode");
	public static final class_3414 terrasteelCraft = makeSoundEvent("terrasteel_craft");
	public static final class_3414 thermalily = makeSoundEvent("thermalily");
	public static final class_3414 unholyCloak = makeSoundEvent("unholy_cloak");
	public static final class_3414 way = makeSoundEvent("way");

	public static final class_3414 gaiaMusic1 = makeSoundEvent("music.gaia1");
	public static final class_3414 gaiaMusic2 = makeSoundEvent("music.gaia2");

	private static class_3414 makeSoundEvent(String name) {
		class_2960 loc = prefix(name);
		return class_2378.method_10230(class_2378.field_11156, loc, new class_3414(loc));
	}

	public static void init() {

	}

	private ModSounds() {}
}
