/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.core.handler;

import vazkii.botania.api.internal.IManaNetwork;
import vazkii.botania.api.mana.ManaNetworkCallback.Action;
import vazkii.botania.api.mana.ManaNetworkCallback.ManaBlockType;

import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import java.util.*;

public final class ManaNetworkHandler implements IManaNetwork {

	public static final ManaNetworkHandler instance = new ManaNetworkHandler();

	private final WeakHashMap<class_1937, Set<class_2586>> manaPools = new WeakHashMap<>();
	private final WeakHashMap<class_1937, Set<class_2586>> manaCollectors = new WeakHashMap<>();

	public void onNetworkEvent(class_2586 be, ManaBlockType type, Action action) {
		Map<class_1937, Set<class_2586>> map = type == ManaBlockType.COLLECTOR ? manaCollectors : manaPools;
		if (action == Action.ADD) {
			add(map, be);
		} else {
			remove(map, be);
		}
	}

	@Override
	public void clear() {
		manaPools.clear();
		manaCollectors.clear();
	}

	@Override
	public class_2586 getClosestPool(class_2338 pos, class_1937 world, int limit) {
		if (manaPools.containsKey(world)) {
			return getClosest(manaPools.get(world), pos, limit);
		}
		return null;
	}

	@Override
	public class_2586 getClosestCollector(class_2338 pos, class_1937 world, int limit) {
		if (manaCollectors.containsKey(world)) {
			return getClosest(manaCollectors.get(world), pos, limit);
		}
		return null;
	}

	public boolean isCollectorIn(class_2586 tile) {
		return isIn(tile, manaCollectors);
	}

	public boolean isPoolIn(class_2586 tile) {
		return isIn(tile, manaPools);
	}

	private boolean isIn(class_2586 tile, Map<class_1937, Set<class_2586>> map) {
		Set<class_2586> set = map.get(tile.method_10997());
		return set != null && set.contains(tile);
	}

	@Nullable
	private class_2586 getClosest(Set<class_2586> tiles, class_2338 pos, int limit) {
		double minDist = Double.MAX_VALUE;
		class_2586 closest = null;

		for (class_2586 te : tiles) {
			if (!te.method_11015()) {
				double distance = te.method_11016().method_10262(pos);
				if (distance <= limit * limit && distance < minDist) {
					minDist = distance;
					closest = te;
				}
			}
		}

		return closest;
	}

	private void remove(Map<class_1937, Set<class_2586>> map, class_2586 tile) {
		class_1937 world = tile.method_10997();

		if (!map.containsKey(world)) {
			return;
		}

		map.get(world).remove(tile);
	}

	private void add(Map<class_1937, Set<class_2586>> map, class_2586 tile) {
		class_1937 world = tile.method_10997();
		map.computeIfAbsent(world, k -> new HashSet<>()).add(tile);
	}

	@Override
	public Set<class_2586> getAllCollectorsInWorld(class_1937 world) {
		return getAllInWorld(manaCollectors, world);
	}

	@Override
	public Set<class_2586> getAllPoolsInWorld(class_1937 world) {
		return getAllInWorld(manaPools, world);
	}

	private Set<class_2586> getAllInWorld(Map<class_1937, Set<class_2586>> map, class_1937 world) {
		Set<class_2586> ret = map.get(world);
		if (ret == null) {
			return Collections.emptySet();
		} else {
			return Collections.unmodifiableSet(ret);
		}
	}

}
