/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.core.handler;

import net.minecraft.class_1860;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2609;
import net.minecraft.class_2741;
import net.minecraft.class_3956;
import vazkii.botania.api.item.IExoflameHeatable;
import vazkii.botania.common.Botania;
import vazkii.botania.mixin.AccessorAbstractFurnaceTileEntity;

public class ExoflameFurnaceHandler {
	public static boolean canSmelt(class_2609 furnace, class_1860<?> recipe) {
		return ((AccessorAbstractFurnaceTileEntity) furnace).botania_canAcceptRecipeOutput(recipe);
	}

	public static class_3956<? extends class_1874> getRecipeType(class_2609 furnace) {
		return ((AccessorAbstractFurnaceTileEntity) furnace).getRecipeType();
	}

	public static class FurnaceExoflameHeatable implements IExoflameHeatable {
		private final class_2609 furnace;

		private class_3956<? extends class_1874> recipeType;
		private class_1874 currentRecipe;

		public FurnaceExoflameHeatable(class_2609 furnace) {
			this.furnace = furnace;
		}

		@Override
		public boolean canSmelt() {
			if (furnace.method_5438(0).method_7960()) {
				return false;
			}
			try {
				if (recipeType == null) {
					this.recipeType = ExoflameFurnaceHandler.getRecipeType(furnace);
				}
				if (currentRecipe != null) { // This is already more caching than Mojang does
					if (currentRecipe.method_8115(furnace, furnace.method_10997())
							&& ExoflameFurnaceHandler.canSmelt(furnace, currentRecipe)) {
						return true;
					}
				}
				currentRecipe = furnace.method_10997().method_8433().method_8132(recipeType, furnace, furnace.method_10997()).orElse(null);
				return ExoflameFurnaceHandler.canSmelt(furnace, currentRecipe);
			} catch (Throwable t) {
				Botania.LOGGER.error("Failed to determine if furnace TE can smelt", t);
				return false;
			}
		}

		@Override
		public int getBurnTime() {
			return ((AccessorAbstractFurnaceTileEntity) furnace).getBurnTime();
		}

		@Override
		public void boostBurnTime() {
			if (getBurnTime() == 0) {
				class_1937 world = furnace.method_10997();
				class_2338 pos = furnace.method_11016();
				world.method_8501(pos, world.method_8320(pos).method_11657(class_2741.field_12548, true));
			}
			int burnTime = ((AccessorAbstractFurnaceTileEntity) furnace).getBurnTime();
			((AccessorAbstractFurnaceTileEntity) furnace).setBurnTime(burnTime + 200);
		}

		@Override
		public void boostCookTime() {
			int cookTime = ((AccessorAbstractFurnaceTileEntity) furnace).getCookTime();
			((AccessorAbstractFurnaceTileEntity) furnace).setCookTime(Math.min(currentRecipe.method_8167() - 1, cookTime + 1));
		}
	}
}
