/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.core.handler;

import top.theillusivec4.curios.api.event.DropRulesCallback;

import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.handler.EquipmentHandler.InventoryEquipmentHandler;
import vazkii.botania.common.integration.curios.CurioIntegration;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public abstract class EquipmentHandler {
	public static EquipmentHandler instance;

	public static void init() {
		if (Botania.curiosLoaded) {
			instance = new CurioIntegration();
			CurioIntegration.init();
			DropRulesCallback.EVENT.register(CurioIntegration::keepCurioDrops);
		} else {
			InventoryEquipmentHandler handler = new InventoryEquipmentHandler();
			instance = handler;
		}
	}

	public static class_1263 getAllWorn(class_1309 living) {
		return instance.getAllWornItems(living);
	}

	public static class_1799 findOrEmpty(class_1792 item, class_1309 living) {
		return instance.findItem(item, living);
	}

	public static class_1799 findOrEmpty(Predicate<class_1799> pred, class_1309 living) {
		return instance.findItem(pred, living);
	}

	public static void initBaubleCap(class_1792 item) {
		if (instance != null) // Happens to be called in ModItems class init, which is too early to know about which handler to use
		{
			instance.registerComponentEvent(item);
		}
	}

	protected abstract class_1263 getAllWornItems(class_1309 living);

	protected abstract class_1799 findItem(class_1792 item, class_1309 living);

	protected abstract class_1799 findItem(Predicate<class_1799> pred, class_1309 living);

	protected abstract void registerComponentEvent(class_1792 item);

	public boolean isAccessory(class_1799 stack) {
		return stack.method_7909() instanceof ItemBauble || stack.method_7909() instanceof IManaItem;
	}

	// Fallback equipment handler for curios-less (or baubles-less) installs.
	public static class InventoryEquipmentHandler extends EquipmentHandler {
		private final Map<class_1657, class_1799[]> map = new WeakHashMap<>();

		public void onPlayerTick(class_1657 player) {
			player.field_6002.method_16107().method_15396("botania:tick_wearables");

			class_1799[] oldStacks = map.computeIfAbsent(player, p -> {
				class_1799[] array = new class_1799[9];
				Arrays.fill(array, class_1799.field_8037);
				return array;
			});

			class_1661 inv = player.field_7514;
			for (int i = 0; i < 9; i++) {
				class_1799 old = oldStacks[i];
				class_1799 current = inv.method_5438(i);

				if (!class_1799.method_7973(old, current)) {
					if (old.method_7909() instanceof ItemBauble) {
						player.method_6127().method_26847(((ItemBauble) old.method_7909()).getEquippedAttributeModifiers(old));
						((ItemBauble) old.method_7909()).onUnequipped(old, player);
					}
					if (canEquip(current, player)) {
						player.method_6127().method_26854(((ItemBauble) current.method_7909()).getEquippedAttributeModifiers(current));
						((ItemBauble) current.method_7909()).onEquipped(current, player);
					}
					oldStacks[i] = current.method_7972(); // shift-clicking mutates the stack we stored,
					// making it empty and failing the equality check - let's avoid that
				}

				if (canEquip(current, player)) {
					((ItemBauble) current.method_7909()).onWornTick(current, player);
				}
			}
			player.field_6002.method_16107().method_15407();
		}

		@Override
		protected class_1263 getAllWornItems(class_1309 living) {
			return new class_1277(0);
		}

		@Override
		protected class_1799 findItem(class_1792 item, class_1309 living) {
			if (living instanceof class_1657) {
				class_1661 inv = ((class_1657) living).field_7514;
				for (int i = 0; i < 9; i++) {
					class_1799 stack = inv.method_5438(i);
					if (stack.method_7909() == item && canEquip(stack, living)) {
						return stack;
					}
				}
			}
			return class_1799.field_8037;
		}

		@Override
		protected class_1799 findItem(Predicate<class_1799> pred, class_1309 living) {
			if (living instanceof class_1657) {
				class_1661 inv = ((class_1657) living).field_7514;
				for (int i = 0; i < 9; i++) {
					class_1799 stack = inv.method_5438(i);
					if (pred.test(stack) && canEquip(stack, living)) {
						return stack;
					}
				}
			}
			return class_1799.field_8037;
		}

		@Override
		protected void registerComponentEvent(class_1792 item) {}

		private static boolean canEquip(class_1799 stack, class_1309 player) {
			return stack.method_7909() instanceof ItemBauble && ((ItemBauble) stack.method_7909()).canEquip(stack, player);
		}
	}
}
