/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import dev.onyxstudios.cca.api.v3.component.Component;

public class KeptItemsComponent implements Component {
	private final List<class_1799> stacks = new ArrayList<>();

	public void addAll(Collection<class_1799> stack) {
		stacks.addAll(stack);
	}

	public List<class_1799> getStacks() {
		return stacks;
	}

	@Override
	public void readFromNbt(class_2487 tag) {
		stacks.clear();
		class_2499 list = tag.method_10554("stacks", 10);
		for (class_2520 t : list) {
			stacks.add(class_1799.method_7915((class_2487) t));
		}
	}

	@Override
	public void writeToNbt(class_2487 tag) {
		class_2499 list = new class_2499();
		for (class_1799 stack : stacks) {
			list.add(stack.method_7953(new class_2487()));
		}
		tag.method_10566("stacks", list);
	}
}
