/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.components;

import vazkii.botania.common.block.subtile.functional.SubTileSpectranthemum;
import vazkii.botania.common.block.tile.TileAlfPortal;
import vazkii.botania.common.block.tile.TileAltar;


import dev.onyxstudios.cca.api.v3.component.Component;
import net.minecraft.class_2487;

// Component for misc internal Botania flags
public class ItemFlagsComponent implements Component {
	public boolean spectranthemumTeleported = false;
	public boolean alfPortalSpawned = false;
	public boolean apothecarySpawned = false;

	@Override
	public void readFromNbt(class_2487 tag) {
		spectranthemumTeleported = tag.method_10577(SubTileSpectranthemum.TAG_TELEPORTED);
		alfPortalSpawned = tag.method_10577(TileAlfPortal.TAG_PORTAL_FLAG);
		apothecarySpawned = tag.method_10577(TileAltar.ITEM_TAG_APOTHECARY_SPAWNED);
	}

	@Override
	public void writeToNbt(class_2487 tag) {
		tag.method_10556(SubTileSpectranthemum.TAG_TELEPORTED, spectranthemumTeleported);
		tag.method_10556(TileAlfPortal.TAG_PORTAL_FLAG, alfPortalSpawned);
		tag.method_10556(TileAltar.ITEM_TAG_APOTHECARY_SPAWNED, apothecarySpawned);
	}
}
