/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.compat.rei.puredaisy;

import com.google.common.collect.ImmutableList;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.compat.rei.BotaniaRecipeDisplay;
import vazkii.botania.common.crafting.RecipePureDaisy;

import java.util.Collections;

import me.shedaniel.rei.api.EntryStack;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class PureDaisyREIDisplay extends BotaniaRecipeDisplay<RecipePureDaisy> {

	public PureDaisyREIDisplay(RecipePureDaisy recipe) {
		super(recipe);
		ImmutableList.Builder<EntryStack> inputs = ImmutableList.builder();
		for (class_2680 state : recipe.getInput().getDisplayed()) {
			if (!state.method_26227().method_15769()) {
				inputs.add(EntryStack.create(state.method_26227().method_15772()));
			} else {
				inputs.add(EntryStack.create(state.method_26204()));
			}
		}
		this.inputs = Collections.singletonList(inputs.build());
		this.outputs = Collections.singletonList(EntryStack.create(recipe.getOutputState().method_26204()));
	}

	/*todo implement time-based hints?
	public int getProcessingTime() {
		return recipe.getTime();
	}
	*/

	@Override
	public int getManaCost() {
		return 0;
	}

	@Override
	public @NotNull class_2960 getRecipeCategory() {
		return RecipePureDaisy.TYPE_ID;
	}
}
