/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.compat.rei.orechid;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.lib.ResourceLocationHelper;

import java.util.Collections;
import java.util.Map;

import me.shedaniel.rei.api.EntryStack;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2960;

public class OrechidREIDisplay extends OrechidBaseREIDisplay {

	public OrechidREIDisplay(OrechidRecipeWrapper recipe) {
		super(recipe);
		this.stone = Collections.singletonList(Collections.singletonList(EntryStack.create(new class_1799(class_2246.field_10340, 64))));
	}

	@Override
	protected Map<class_2960, Integer> getOreWeights() {
		return BotaniaAPI.instance().getOreWeights();
	}

	@Override
	public @NotNull class_2960 getRecipeCategory() {
		return ResourceLocationHelper.prefix("orechid");
	}
}
