/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.compat.rei.orechid;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.compat.rei.CategoryUtils;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeDisplay;

@Environment(EnvType.CLIENT)
public abstract class OrechidBaseREIDisplay implements RecipeDisplay {
	protected List<List<EntryStack>> stone;
	List<List<EntryStack>> ores;

	public OrechidBaseREIDisplay(OrechidRecipeWrapper recipe) {
		final int myWeight = recipe.entry.getValue();
		final int amount = Math.max(1, Math.round((float) (myWeight * 64) / CategoryUtils.getTotalOreWeight(getOreWeights(), myWeight)));

		// Shouldn't ever return an empty list since the ore weight
		// list is filtered to only have ores with ItemBlocks
		List<class_1799> stackList = class_3481.method_15073().method_30213(recipe.entry.getKey())
				.method_15138()
				.stream()
				.filter(s -> s.method_8389() != class_1802.field_8162)
				.map(class_1799::new)
				.collect(Collectors.toList());

		for (class_1799 stack : stackList) {
			stack.method_7939(amount);
		}
		ores = Collections.singletonList(EntryStack.ofItemStacks(stackList));
	}

	protected abstract Map<class_2960, Integer> getOreWeights();

	@Override
	public @NotNull List<List<EntryStack>> getInputEntries() {
		return stone;
	}

	@Override
	public @NotNull List<List<EntryStack>> getResultingEntries() {
		return ores;
	}
}
