/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.compat.rei.manapool;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.compat.rei.BotaniaRecipeDisplay;
import vazkii.botania.common.crafting.RecipeManaInfusion;

import javax.annotation.Nullable;

import java.util.Optional;

@Environment(EnvType.CLIENT)
public class ManaPoolREIDisplay extends BotaniaRecipeDisplay<RecipeManaInfusion> {
	@Nullable
	private class_2680 catalyst;

	public ManaPoolREIDisplay(RecipeManaInfusion recipe) {
		super(recipe);
		this.catalyst = recipe.getCatalyst();
	}

	public Optional<class_2680> getCatalyst() {
		return Optional.ofNullable(this.catalyst);
	}

	@Override
	public int getManaCost() {
		return recipe.getManaToConsume();
	}

	@Override
	public @NotNull class_2960 getRecipeCategory() {
		return RecipeManaInfusion.TYPE_ID;
	}
}
