/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.compat.rei.elventrade;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1074;
import net.minecraft.class_1159;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.compat.rei.CategoryUtils;
import vazkii.botania.common.crafting.RecipeElvenTrade;
import vazkii.botania.common.lib.ResourceLocationHelper;

import java.util.ArrayList;
import java.util.List;

import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.widgets.Widgets;
import me.shedaniel.rei.gui.widget.Widget;

@Environment(EnvType.CLIENT)
public class ElvenTradeREICategory implements RecipeCategory<ElvenTradeREIDisplay> {
	private EntryStack gateway = EntryStack.create(new class_1799(ModBlocks.alfPortal));
	private class_2960 TRADE_OVERLAY = ResourceLocationHelper.prefix("textures/gui/elven_trade_overlay.png");

	@Override
	public @NotNull class_2960 getIdentifier() {
		return RecipeElvenTrade.TYPE_ID;
	}

	@Override
	public @NotNull EntryStack getLogo() {
		return gateway;
	}

	@Override
	public @NotNull String getCategoryName() {
		return class_1074.method_4662("botania.nei.elvenTrade");
	}

	@Override
	public @NotNull List<Widget> setupDisplay(ElvenTradeREIDisplay display, Rectangle bounds) {
		List<Widget> widgets = new ArrayList<>();
		Point center = new Point(bounds.getCenterX() - 8, bounds.getCenterY() - 4);
		widgets.add(CategoryUtils.drawRecipeBackground(bounds));
		widgets.add(Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
			CategoryUtils.drawOverlay(helper, matrices, TRADE_OVERLAY, center.x - 45, center.y - 34, 20, 19, 71, 75);
			drawPortal(matrices, center);
		}));
		int x = center.x - 20;
		for (List<EntryStack> o : display.getInputEntries()) {
			widgets.add(Widgets.createSlot(new Point(x, center.y - 40)).entries(o).disableBackground());
			x += 18;
		}
		x = center.x + 28;
		for (List<EntryStack> o : display.getResultingEntries()) {
			widgets.add(Widgets.createSlot(new Point(x, center.y)).entries(o).disableBackground());
			x += 18;
		}
		return widgets;
	}

	@Override
	public int getDisplayHeight() {
		return 100;
	}

	void drawPortal(class_4587 matrices, Point point) {
		class_1058 sprite = class_310.method_1551().method_1549(class_1059.field_5275).apply(ResourceLocationHelper.prefix("block/alfheim_portal_swirl"));
		class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
		class_4588 v = immediate.getBuffer(class_1921.method_23577());
		int startX = point.x - 43;
		int startY = point.y - 17;
		int stopX = startX + 48;
		int stopY = startY + 48;
		class_1159 mat = matrices.method_23760().method_23761();
		class_4581 n = matrices.method_23760().method_23762();
		v.method_22918(mat, startX, startY, 0).method_22915(1f, 1f, 1f, 1f).method_22913(sprite.method_4594(), sprite.method_4593()).method_22916(0xF000F0).method_23763(n, 1, 0, 0).method_1344();
		v.method_22918(mat, startX, stopY, 0).method_22915(1f, 1f, 1f, 1f).method_22913(sprite.method_4594(), sprite.method_4575()).method_22916(0xF000F0).method_23763(n, 1, 0, 0).method_1344();
		v.method_22918(mat, stopX, stopY, 0).method_22915(1f, 1f, 1f, 1f).method_22913(sprite.method_4577(), sprite.method_4575()).method_22916(0xF000F0).method_23763(n, 1, 0, 0).method_1344();
		v.method_22918(mat, stopX, startY, 0).method_22915(1f, 1f, 1f, 1f).method_22913(sprite.method_4577(), sprite.method_4593()).method_22916(0xF000F0).method_23763(n, 1, 0, 0).method_1344();
		immediate.method_22993();
	}
}
