/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.compat.rei;

import com.mojang.blaze3d.systems.RenderSystem;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_4587;
import java.util.Map;

import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.impl.Internals;

@Environment(EnvType.CLIENT)
public interface CategoryUtils {
	/**
	 * method that always returns a "lighter" REI recipe background panel.
	 */
	static Widget drawRecipeBackground(Rectangle bounds) {
		return Internals.getWidgetsProvider().createPanelWidget(bounds).yTextureOffset(0);
	}

	/**
	 * Widgets#createTexturedWidget doesn't allow partial transparency, so this is called in createDrawableWidget
	 * instead.
	 */
	static void drawOverlay(class_332 helper, class_4587 matrices, class_2960 texture, int x, int y, int u, int v, int width, int height) {
		RenderSystem.enableAlphaTest();
		RenderSystem.enableBlend();
		class_310.method_1551().method_1531().method_22813(texture);
		helper.method_25302(matrices, x, y, u, v, width, height);
		RenderSystem.disableBlend();
		RenderSystem.disableAlphaTest();
	}

	/**
	 * spin the wheel and laugh at god! Used for creating the Apothecary and Rune Altar categories.
	 */
	static Point rotatePointAbout(Point in, Point about, double degrees) {
		double rad = degrees * Math.PI / 180.0;
		double newX = Math.cos(rad) * (in.x - about.x) - Math.sin(rad) * (in.y - about.y) + about.x;
		double newY = Math.sin(rad) * (in.x - about.x) + Math.cos(rad) * (in.y - about.y) + about.y;
		return new Point((int) newX, (int) newY);
	}

	static boolean doesOreExist(class_2960 tagId) {
		class_3494<class_2248> tag = class_3481.method_15073().method_30210(tagId);
		return tag != null && !tag.method_15138().isEmpty();
	}

	static float getTotalOreWeight(Map<class_2960, Integer> weights, int myWeight) {
		return (weights.entrySet().stream()
				.filter(e -> doesOreExist(e.getKey()))
				.map(Map.Entry::getValue)
				.reduce(Integer::sum)).orElse(myWeight * 64 * 64);
	}
}
