/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.compat.rei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IAncientWillContainer;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.compat.rei.brewery.BreweryREICategory;
import vazkii.botania.common.compat.rei.brewery.BreweryREIDisplay;
import vazkii.botania.common.compat.rei.elventrade.ElvenTradeREICategory;
import vazkii.botania.common.compat.rei.elventrade.ElvenTradeREIDisplay;
import vazkii.botania.common.compat.rei.manapool.ManaPoolREICategory;
import vazkii.botania.common.compat.rei.manapool.ManaPoolREIDisplay;
import vazkii.botania.common.compat.rei.orechid.OrechidIgnemREIDisplay;
import vazkii.botania.common.compat.rei.orechid.OrechidREICategory;
import vazkii.botania.common.compat.rei.orechid.OrechidREIDisplay;
import vazkii.botania.common.compat.rei.orechid.OrechidRecipeWrapper;
import vazkii.botania.common.compat.rei.petalapothecary.PetalApothecaryREICategory;
import vazkii.botania.common.compat.rei.petalapothecary.PetalApothecaryREIDisplay;
import vazkii.botania.common.compat.rei.puredaisy.PureDaisyREICategory;
import vazkii.botania.common.compat.rei.puredaisy.PureDaisyREIDisplay;
import vazkii.botania.common.compat.rei.runicaltar.RunicAltarREICategory;
import vazkii.botania.common.compat.rei.runicaltar.RunicAltarREIDisplay;
import vazkii.botania.common.crafting.*;
import vazkii.botania.common.item.ItemAncientWill;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraPick;
import vazkii.botania.common.item.lens.ItemLens;

import java.util.*;
import java.util.stream.Collectors;

import static vazkii.botania.common.compat.rei.CategoryUtils.doesOreExist;
import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.plugins.REIPluginV0;
import me.shedaniel.rei.plugin.crafting.DefaultCustomDisplay;

@Environment(EnvType.CLIENT)
public class BotaniaREIPlugin implements REIPluginV0 {
	public static final class_2960 PLUGIN = prefix("rei_plugin");

	@Override
	public class_2960 getPluginIdentifier() {
		return PLUGIN;
	}

	@Override
	public void registerPluginCategories(RecipeHelper helper) {
		helper.registerCategories(
				new BreweryREICategory(),
				new PureDaisyREICategory(),
				new RunicAltarREICategory(),
				new PetalApothecaryREICategory(),
				new ElvenTradeREICategory(),
				new ManaPoolREICategory(),
				new OrechidREICategory(ModSubtiles.orechid),
				new OrechidREICategory(ModSubtiles.orechidIgnem)
		);
	}

	@Override
	public void registerRecipeDisplays(RecipeHelper helper) {
		registerAncientWillRecipeWrapper(helper);
		registerCompositeLensRecipeWrapper(helper);
		registerTerraPickTippingRecipeWrapper(helper);

		helper.registerRecipes(RecipePetals.TYPE_ID, RecipePetals.class, PetalApothecaryREIDisplay::new);
		helper.registerRecipes(RecipeBrew.TYPE_ID, RecipeBrew.class, BreweryREIDisplay::new);
		//rawtyped predicate due to rei oversight?
		//helper.registerRecipes(RecipeElvenTrade.TYPE_ID, (Predicate<Recipe>) recipe -> recipe instanceof RecipeElvenTrade && recipe.getId().getNamespace().equals(LibMisc.MOD_ID) && !recipe.getId().getPath().contains("return"), ElvenTradeREIDisplay::new);
		helper.registerRecipes(RecipeElvenTrade.TYPE_ID, RecipeElvenTrade.class, ElvenTradeREIDisplay::new);
		helper.registerRecipes(RecipeManaInfusion.TYPE_ID, RecipeManaInfusion.class, ManaPoolREIDisplay::new);
		registerOrechidRecipes(helper, false);
		registerOrechidRecipes(helper, true);
		helper.registerRecipes(RecipePureDaisy.TYPE_ID, RecipePureDaisy.class, PureDaisyREIDisplay::new);
		helper.registerRecipes(RecipeRuneAltar.TYPE_ID, RecipeRuneAltar.class, RunicAltarREIDisplay::new);
	}

	@Override
	public void registerOthers(RecipeHelper helper) {
		Set<class_1935> apothecaries = ImmutableSet.of(
				ModBlocks.defaultAltar,
				ModBlocks.desertAltar,
				ModBlocks.forestAltar,
				ModBlocks.fungalAltar,
				ModBlocks.mesaAltar,
				ModBlocks.mossyAltar,
				ModBlocks.mountainAltar,
				ModBlocks.plainsAltar,
				ModBlocks.swampAltar,
				ModBlocks.taigaAltar);
		for (class_1935 altar : apothecaries) {
			helper.registerWorkingStations(RecipePetals.TYPE_ID, EntryStack.create(altar));
		}
		helper.registerWorkingStations(RecipeBrew.TYPE_ID, EntryStack.create(ModBlocks.brewery));
		helper.registerWorkingStations(RecipeElvenTrade.TYPE_ID, EntryStack.create(ModBlocks.alfPortal));
		Set<class_1935> manaPools = ImmutableSet.of(
				ModBlocks.manaPool,
				ModBlocks.dilutedPool,
				ModBlocks.fabulousPool
		);
		for (class_1935 pool : manaPools) {
			helper.registerWorkingStations(RecipeManaInfusion.TYPE_ID, EntryStack.create(pool));
		}
		helper.registerWorkingStations(prefix("orechid"), EntryStack.create(ModSubtiles.orechid), EntryStack.create(ModSubtiles.orechidFloating));
		helper.registerWorkingStations(prefix("orechid_ignem"), EntryStack.create(ModSubtiles.orechidIgnem), EntryStack.create(ModSubtiles.orechidIgnemFloating));
		helper.registerWorkingStations(RecipePureDaisy.TYPE_ID, EntryStack.create(ModSubtiles.pureDaisy), EntryStack.create(ModSubtiles.pureDaisyFloating));
		helper.registerWorkingStations(RecipeRuneAltar.TYPE_ID, EntryStack.create(ModBlocks.runeAltar));

		helper.removeAutoCraftButton(RecipePetals.TYPE_ID);
		helper.removeAutoCraftButton(RecipeBrew.TYPE_ID);
		helper.removeAutoCraftButton(RecipeElvenTrade.TYPE_ID);
		helper.removeAutoCraftButton(RecipeManaInfusion.TYPE_ID);
		helper.removeAutoCraftButton(prefix("orechid"));
		helper.removeAutoCraftButton(prefix("orechid_ignem"));
		helper.removeAutoCraftButton(RecipePureDaisy.TYPE_ID);
		helper.removeAutoCraftButton(RecipeRuneAltar.TYPE_ID);
	}

	void registerAncientWillRecipeWrapper(RecipeHelper helper) {
		ImmutableList.Builder<List<EntryStack>> input = ImmutableList.builder();
		ImmutableList.Builder<EntryStack> output = ImmutableList.builder();
		Set<class_1799> wills = ImmutableSet.of(new class_1799(ModItems.ancientWillAhrim), new class_1799(ModItems.ancientWillDharok), new class_1799(ModItems.ancientWillGuthan), new class_1799(ModItems.ancientWillKaril), new class_1799(ModItems.ancientWillTorag), new class_1799(ModItems.ancientWillVerac));
		IAncientWillContainer container = (IAncientWillContainer) ModItems.terrasteelHelm;

		class_1799 helmet = new class_1799(ModItems.terrasteelHelm);
		input.add(Collections.singletonList(EntryStack.create(helmet)));
		input.add(EntryStack.ofItemStacks(wills));
		for (class_1799 will : wills) {
			class_1799 copy = helmet.method_7972();
			container.addAncientWill(copy, ((ItemAncientWill) will.method_7909()).type);
			output.add(EntryStack.create(copy));
		}
		helper.registerDisplay(new DefaultCustomDisplay(null, input.build(), output.build()));
	}

	void registerCompositeLensRecipeWrapper(RecipeHelper helper) {
		List<class_1799> lensStacks = class_3489.method_15106().method_30213(prefix("lens"))
				.method_15138().stream()
				.map(class_1799::new)
				.filter(s -> !((ItemLens) s.method_7909()).isControlLens(s))
				.filter(s -> ((ItemLens) s.method_7909()).isCombinable(s))
				.collect(Collectors.toList());
		List<class_1792> lenses = lensStacks.stream().map(class_1799::method_7909).collect(Collectors.toList());
		List<List<EntryStack>> inputs = Arrays.asList(EntryStack.ofItemStacks(lensStacks), Collections.singletonList(EntryStack.create(new class_1799(class_1802.field_8777))), EntryStack.ofItemStacks(lensStacks));
		int end = lenses.size() - 1;

		List<class_1799> firstInput = new ArrayList<>();
		List<class_1799> secondInput = new ArrayList<>();
		List<class_1799> outputs = new ArrayList<>();
		for (int i = 1; i <= end; i++) {
			class_1799 firstLens = new class_1799(lenses.get(i));
			for (class_1792 secondLens : lenses) {
				if (secondLens == firstLens.method_7909()) {
					continue;
				}

				class_1799 secondLensStack = new class_1799(secondLens);
				if (((ItemLens) firstLens.method_7909()).canCombineLenses(firstLens, secondLensStack)) {
					firstInput.add(firstLens);
					secondInput.add(secondLensStack);
					outputs.add(((ItemLens) firstLens.method_7909()).setCompositeLens(firstLens.method_7972(), secondLensStack));
				}
			}
		}
		inputs.set(0, EntryStack.ofItemStacks(firstInput));
		inputs.set(2, EntryStack.ofItemStacks(secondInput));

		helper.registerDisplay(new DefaultCustomDisplay(null, inputs, EntryStack.ofItemStacks(outputs)));
	}

	void registerTerraPickTippingRecipeWrapper(RecipeHelper helper) {
		List<List<EntryStack>> inputs = ImmutableList.of(ImmutableList.of(EntryStack.create(ModItems.terraPick)), ImmutableList.of(EntryStack.create(ModItems.elementiumPick)));
		class_1799 output = new class_1799(ModItems.terraPick);
		ItemTerraPick.setTipped(output);

		helper.registerDisplay(new DefaultCustomDisplay(null, inputs, Collections.singletonList(EntryStack.create(output))));
	}

	void registerOrechidRecipes(RecipeHelper helper, boolean isIgnem) {
		Map<class_2960, Integer> oreWeights = isIgnem ? BotaniaAPI.instance().getNetherOreWeights() : BotaniaAPI.instance().getOreWeights();
		List<OrechidRecipeWrapper> orechidRecipes = oreWeights.entrySet().stream()
				.filter(e -> doesOreExist(e.getKey()))
				.map(OrechidRecipeWrapper::new)
				.sorted()
				.collect(Collectors.toList());
		for (OrechidRecipeWrapper recipe : orechidRecipes) {
			if (isIgnem) {
				helper.registerDisplay(new OrechidIgnemREIDisplay(recipe));
			} else {
				helper.registerDisplay(new OrechidREIDisplay(recipe));
			}
		}
	}
}
