/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.brew;

import vazkii.botania.common.brew.potion.*;
import vazkii.botania.common.lib.LibPotionNames;

import static vazkii.botania.common.block.ModBlocks.register;

import net.minecraft.class_1291;
import net.minecraft.class_2378;

public class ModPotions {

	public static final class_1291 soulCross = new PotionSoulCross();
	public static final class_1291 featherfeet = new PotionFeatherfeet();
	public static final class_1291 emptiness = new PotionEmptiness();
	public static final class_1291 bloodthrst = new PotionBloodthirst();
	public static final class_1291 allure = new PotionAllure();
	public static final class_1291 clear = new PotionClear();

	public static void registerPotions() {
		class_2378<class_1291> r = class_2378.field_11159;
		register(r, LibPotionNames.SOUL_CROSS, soulCross);
		register(r, LibPotionNames.FEATHER_FEET, featherfeet);
		register(r, LibPotionNames.EMPTINESS, emptiness);
		register(r, LibPotionNames.BLOODTHIRST, bloodthrst);
		register(r, LibPotionNames.ALLURE, allure);
		register(r, LibPotionNames.CLEAR, clear);
	}
}
