/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile.string;

import vazkii.botania.api.wand.ITileBound;
import vazkii.botania.common.block.tile.TileMod;

import javax.annotation.Nullable;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3000;

public abstract class TileRedString extends TileMod implements ITileBound, class_3000 {

	private class_2338 binding;

	public TileRedString(class_2591<?> type) {
		super(type);
	}

	@Override
	public void method_16896() {
		class_2350 dir = getOrientation();
		class_2338 pos_ = method_11016();
		int range = getRange();
		class_2338 currBinding = getBinding();
		setBinding(null);

		for (int i = 0; i < range; i++) {
			pos_ = pos_.method_10093(dir);
			if (field_11863.method_22347(pos_)) {
				continue;
			}

			class_2586 tile = field_11863.method_8321(pos_);
			if (tile instanceof TileRedString) {
				continue;
			}

			if (acceptBlock(pos_)) {
				setBinding(pos_);
				if (currBinding == null || !currBinding.equals(pos_)) {
					onBound(pos_);
				}
				break;
			}
		}
	}

	public int getRange() {
		return 8;
	}

	public abstract boolean acceptBlock(class_2338 pos);

	public void onBound(class_2338 pos) {}

	@Nullable
	@Override
	public class_2338 getBinding() {
		return binding;
	}

	public void setBinding(class_2338 binding) {
		this.binding = binding;
	}

	public class_2350 getOrientation() {
		return method_11010().method_11654(class_2741.field_12525);
	}

	public class_2586 getTileAtBinding() {
		class_2338 binding = getBinding();
		return binding == null || field_11863 == null ? null : field_11863.method_8321(binding);
	}

	public class_2680 getStateAtBinding() {
		class_2338 binding = getBinding();
		return binding == null ? class_2246.field_10124.method_9564() : field_11863.method_8320(binding);
	}

	public class_2248 getBlockAtBinding() {
		return getStateAtBinding().method_26204();
	}
}
