/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile.mana;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_3000;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;

public class TileTurntable extends TileMod implements class_3000 {
	private static final String TAG_SPEED = "speed";
	private static final String TAG_BACKWARDS = "backwards";

	private int speed = 1;
	private boolean backwards = false;

	public TileTurntable() {
		super(ModTiles.TURNTABLE);
	}

	@Override
	public void method_16896() {
		boolean redstone = false;

		for (class_2350 dir : class_2350.values()) {
			int redstoneSide = field_11863.method_8499(field_11867.method_10093(dir), dir);
			if (redstoneSide > 0) {
				redstone = true;
			}
		}

		if (!redstone) {
			class_2586 tile = field_11863.method_8321(field_11867.method_10084());
			if (tile instanceof TileSpreader) {
				TileSpreader spreader = (TileSpreader) tile;
				spreader.rotationX += speed * (backwards ? -1 : 1);
				if (spreader.rotationX >= 360F) {
					spreader.rotationX -= 360F;
				}
				if (!field_11863.field_9236) {
					spreader.checkForReceiver();
				}
			}
		}
	}

	@Override
	public void writePacketNBT(class_2487 cmp) {
		cmp.method_10569(TAG_SPEED, speed);
		cmp.method_10556(TAG_BACKWARDS, backwards);
	}

	@Override
	public void readPacketNBT(class_2487 cmp) {
		speed = cmp.method_10550(TAG_SPEED);
		backwards = cmp.method_10577(TAG_BACKWARDS);
	}

	public void onWanded(class_1657 player, class_1799 wand, class_2350 side) {
		if ((player != null && player.method_5715()) || (player == null && side == class_2350.field_11033)) {
			backwards = !backwards;
		} else {
			speed = speed == 6 ? 1 : speed + 1;
		}
		VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
	}

	@Environment(EnvType.CLIENT)
	public void renderHUD(class_4587 ms, class_310 mc) {
		int color = 0xAA006600;

		char motion = backwards ? '<' : '>';
		String speed = class_124.field_1067 + "";
		for (int i = 0; i < this.speed; i++) {
			speed = speed + motion;
		}

		int x = mc.method_22683().method_4486() / 2 - mc.field_1772.method_1727(speed) / 2;
		int y = mc.method_22683().method_4502() / 2 - 15;
		mc.field_1772.method_1720(ms, speed, x, y, color);
	}

}
