/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile.mana;

import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_3000;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;

public class TilePump extends TileMod implements class_3000 {
	private static final String TAG_ACTIVE = "active";

	public float innerRingPos;
	private boolean active = false;
	public boolean hasCart = false;
	public boolean hasCartOnTop = false;
	public float moving = 0F;

	public int comparator;
	public boolean hasRedstone = false;
	private int lastComparator = 0;

	public TilePump() {
		super(ModTiles.PUMP);
	}

	@Override
	public void method_16896() {
		hasRedstone = false;
		for (class_2350 dir : class_2350.values()) {
			int redstoneSide = field_11863.method_8499(field_11867.method_10093(dir), dir);
			if (redstoneSide > 0) {
				hasRedstone = true;
				break;
			}
		}

		float max = 8F;
		float min = 0F;

		float incr = max / 10F;

		if (innerRingPos < max && active && moving >= 0F) {
			innerRingPos += incr;
			moving = incr;
			if (innerRingPos >= max) {
				innerRingPos = Math.min(max, innerRingPos);
				moving = 0F;
				for (int x = 0; x < 2; x++) {
					field_11863.method_8406(class_2398.field_11251, method_11016().method_10263() + Math.random(), method_11016().method_10264() + Math.random(), method_11016().method_10260() + Math.random(), 0, 0, 0);
				}
			}
		} else if (innerRingPos > min) {
			innerRingPos -= incr * 2;
			moving = -incr * 2;
			if (innerRingPos <= min) {
				innerRingPos = Math.max(min, innerRingPos);
				moving = 0F;
			}
		}

		if (!hasCartOnTop) {
			comparator = 0;
		}
		if (!hasCart && active) {
			setActive(false);
		}
		if (active && hasRedstone) {
			setActive(false);
		}

		hasCart = false;
		hasCartOnTop = false;

		if (comparator != lastComparator) {
			field_11863.method_8455(field_11867, method_11010().method_26204());
		}
		lastComparator = comparator;
	}

	@Override
	public void writePacketNBT(class_2487 cmp) {
		cmp.method_10556(TAG_ACTIVE, active);
	}

	@Override
	public void readPacketNBT(class_2487 cmp) {
		active = cmp.method_10577(TAG_ACTIVE);
	}

	public void setActive(boolean active) {
		if (!field_11863.field_9236) {
			boolean diff = this.active != active;
			this.active = active;
			if (diff) {
				VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
			}
		}
	}
}
