/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile.mana;

import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ILens;
import vazkii.botania.api.mana.ITinyPlanetExcempt;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileExposedSimpleInventory;

public class TilePrism extends TileExposedSimpleInventory {
	public TilePrism() {
		super(ModTiles.PRISM);
	}

	public void onBurstCollision(IManaBurst burst) {
		class_1799 lens = getItemHandler().method_5438(0);
		boolean active = !method_11010().method_11654(class_2741.field_12484);
		boolean valid = !lens.method_7960() && lens.method_7909() instanceof ILens && (!(lens.method_7909() instanceof ITinyPlanetExcempt) || ((ITinyPlanetExcempt) lens.method_7909()).shouldPull(lens));

		if (active) {
			burst.setSourceLens(valid ? lens.method_7972() : class_1799.field_8037);
			burst.setColor(0xFFFFFF);
			burst.setGravity(0F);

			if (valid) {
				class_1297 burstEntity = burst.entity();
				BurstProperties properties = new BurstProperties(burst.getStartingMana(), burst.getMinManaLoss(), burst.getManaLossPerTick(), burst.getBurstGravity(), 1F, burst.getColor());

				((ILens) lens.method_7909()).apply(lens, properties);

				burst.setColor(properties.color);
				burst.setStartingMana(properties.maxMana);
				burst.setMinManaLoss(properties.ticksBeforeManaLoss);
				burst.setManaLossPerTick(properties.manaLossPerTick);
				burst.setGravity(properties.gravity);
				burst.setBurstMotion(burstEntity.method_18798().method_10216() * properties.motionModifier,
						burstEntity.method_18798().method_10214() * properties.motionModifier,
						burstEntity.method_18798().method_10215() * properties.motionModifier);
			}
		}
	}

	@Override
	protected class_1277 createItemHandler() {
		return new class_1277(1) {
			@Override
			public boolean method_5437(int index, class_1799 stack) {
				return !stack.method_7960() && stack.method_7909() instanceof ILens;
			}
		};
	}

	@Override
	public void method_5431() {
		super.method_5431();
		if (field_11863 != null && !field_11863.field_9236) {
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
			class_2680 state = method_11010();
			boolean hasLens = !getItemHandler().method_5438(0).method_7960();
			if (state.method_26204() != ModBlocks.prism || state.method_11654(BotaniaStateProps.HAS_LENS) != hasLens) {
				class_2680 base = state.method_26204() == ModBlocks.prism ? state : ModBlocks.prism.method_9564();
				field_11863.method_8501(field_11867, base.method_11657(BotaniaStateProps.HAS_LENS, hasLens));
			}
		}
	}

}
