/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile.mana;

import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_3000;

public class TileDistributor extends TileMod implements IManaReceiver, class_3000 {
	private final List<IManaReceiver> validPools = new ArrayList<>();

	public TileDistributor() {
		super(ModTiles.DISTRIBUTOR);
	}

	@Override
	public void method_16896() {
		if (field_11863.field_9236) {
			return;
		}
		validPools.clear();
		for (class_2350 dir : class_2350.class_2353.field_11062) {
			class_2338 pos = this.field_11867.method_10093(dir);
			if (field_11863.method_22340(pos)) {
				class_2586 tileAt = field_11863.method_8321(pos);
				if (tileAt instanceof IManaPool && !tileAt.method_11015()) {
					IManaReceiver receiver = (IManaReceiver) tileAt;
					if (!receiver.isFull()) {
						validPools.add(receiver);
					}
				}
			}
		}
	}

	@Override
	public int getCurrentMana() {
		return 0;
	}

	@Override
	public boolean isFull() {
		return validPools.isEmpty();
	}

	@Override
	public void receiveMana(int mana) {
		int tiles = validPools.size();
		if (tiles != 0) {
			int manaForEach = mana / tiles;
			for (IManaReceiver pool : validPools) {
				pool.receiveMana(manaForEach);
			}
		}
	}

	@Override
	public boolean canReceiveManaFromBursts() {
		return !isFull();
	}
}
