/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile.mana;

import com.mojang.datafixers.util.Pair;
import net.minecraft.class_1874;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2609;
import net.minecraft.class_2741;
import net.minecraft.class_3000;
import net.minecraft.class_3419;
import net.minecraft.class_3865;
import net.minecraft.class_3866;
import net.minecraft.class_3956;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.core.handler.ExoflameFurnaceHandler;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.mixin.AccessorAbstractFurnaceTileEntity;

public class TileBellows extends TileMod implements class_3000 {
	private static final String TAG_ACTIVE = "active";

	public float movePos;
	public boolean active = false;
	public float moving = 0F;

	public TileBellows() {
		super(ModTiles.BELLOWS);
	}

	public void interact() {
		if (moving == 0F) {
			setActive(true);
		}
	}

	@Override
	public void method_16896() {
		boolean disable = true;
		class_2586 tile = getLinkedTile();
		if (!active && tile instanceof TilePool) {
			TilePool pool = (TilePool) tile;
			boolean transfer = pool.isDoingTransfer;
			if (transfer) {
				if (pool.ticksDoingTransfer > 0) {
					setActive(true);
				}
				disable = false;
			}
		}

		float max = 0.9F;
		float min = 0F;

		float incr = max / 20F;

		if (movePos < max && active && moving >= 0F) {
			if (moving == 0F) {
				field_11863.method_8396(null, field_11867, ModSounds.bellows, class_3419.field_15245, 0.1F, 3F);
			}

			if (tile instanceof class_2609) {
				class_2609 furnace = (class_2609) tile;
				Pair<class_1874, Boolean> p = canSmelt(furnace);
				if (p != null) {
					class_1874 recipe = p.getFirst();
					boolean canSmelt = p.getSecond();
					if (canSmelt) {
						AccessorAbstractFurnaceTileEntity mFurnace = (AccessorAbstractFurnaceTileEntity) furnace;
						mFurnace.setCookTime(Math.min(recipe.method_8167() - 1, mFurnace.getCookTime() + 20));
						mFurnace.setBurnTime(Math.max(0, mFurnace.getBurnTime() - 10));
					}

					if (furnace instanceof class_3866
							&& furnace.method_11002() && furnace.method_11010().method_11654(class_3865.field_11105)) {
						// [VanillaCopy] BlockFurnace
						double d0 = (double) field_11867.method_10263() + 0.5D;
						double d1 = (double) field_11867.method_10264();
						double d2 = (double) field_11867.method_10260() + 0.5D;
						// Botania: no playSound

						class_2350 enumfacing = furnace.method_11010().method_11654(class_3865.field_11104);
						class_2350.class_2351 enumfacing$axis = enumfacing.method_10166();
						double d3 = 0.52D;
						double d4 = field_11863.field_9229.nextDouble() * 0.6D - 0.3D;
						double d5 = enumfacing$axis == class_2350.class_2351.field_11048 ? (double) enumfacing.method_10148() * 0.52D : d4;
						double d6 = field_11863.field_9229.nextDouble() * 6.0D / 16.0D;
						double d7 = enumfacing$axis == class_2350.class_2351.field_11051 ? (double) enumfacing.method_10165() * 0.52D : d4;
						field_11863.method_8406(class_2398.field_11251, d0 + d5, d1 + d6, d2 + d7, 0.0D, 0.0D, 0.0D);
						field_11863.method_8406(class_2398.field_11240, d0 + d5, d1 + d6, d2 + d7, 0.0D, 0.0D, 0.0D);
					}
				}
			}

			movePos += incr * 3;
			moving = incr * 3;
			if (movePos >= max) {
				movePos = Math.min(max, movePos);
				moving = 0F;
				if (disable) {
					setActive(false);
				}
			}
		} else if (movePos > min) {
			movePos -= incr;
			moving = -incr;
			if (movePos <= min) {
				movePos = Math.max(min, movePos);
				moving = 0F;
			}
		}

	}

	public class_2586 getLinkedTile() {
		class_2350 side = method_11010().method_11654(class_2741.field_12481);
		return field_11863.method_8321(method_11016().method_10093(side));
	}

	@Override
	public void writePacketNBT(class_2487 cmp) {
		cmp.method_10556(TAG_ACTIVE, active);
	}

	@Override
	public void readPacketNBT(class_2487 cmp) {
		active = cmp.method_10577(TAG_ACTIVE);
	}

	public void setActive(boolean active) {
		if (!field_11863.field_9236) {
			boolean diff = this.active != active;
			this.active = active;
			if (diff) {
				VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
			}
		}
	}

	public static Pair<class_1874, Boolean> canSmelt(class_2609 furnace) {
		class_3956<? extends class_1874> rt = ExoflameFurnaceHandler.getRecipeType(furnace);
		class_1874 recipe = furnace.method_10997().method_8433().method_8132(rt, furnace, furnace.method_10997()).orElse(null);
		boolean canSmelt = ExoflameFurnaceHandler.canSmelt(furnace, recipe);
		return Pair.of(recipe, canSmelt);
	}

}
