/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile.corporea;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import vazkii.botania.api.corporea.*;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;

import javax.annotation.Nullable;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class TileCorporeaRetainer extends TileMod {
	private static final String TAG_REQUEST_X = "requestX";
	private static final String TAG_REQUEST_Y = "requestY";
	private static final String TAG_REQUEST_Z = "requestZ";
	private static final String TAG_REQUEST_TYPE = "requestType";
	private static final String TAG_REQUEST_COUNT = "requestCount";
	private static final String TAG_RETAIN_MISSING = "retainMissing";

	private static final Map<class_2960, Function<class_2487, ? extends ICorporeaRequestMatcher>> corporeaMatcherDeserializers = new ConcurrentHashMap<>();
	private static final Map<Class<? extends ICorporeaRequestMatcher>, class_2960> corporeaMatcherSerializers = new ConcurrentHashMap<>();

	private class_2338 requestPos = class_2338.field_10980;

	@Nullable
	private ICorporeaRequestMatcher request;
	private int requestCount;
	private int compValue;
	private boolean retainMissing = false;

	public TileCorporeaRetainer() {
		super(ModTiles.CORPOREA_RETAINER);
	}

	public void remember(class_2338 pos, ICorporeaRequestMatcher request, int count, int missing) {
		if (hasPendingRequest()) {
			return;
		}

		this.requestPos = pos;
		this.request = request;
		this.requestCount = retainMissing ? missing : count;

		compValue = CorporeaHelper.instance().signalStrengthForRequestSize(requestCount);
		method_5431();
	}

	public int getComparatorValue() {
		return compValue;
	}

	public boolean hasPendingRequest() {
		return request != null;
	}

	public void fulfilRequest() {
		if (!hasPendingRequest()) {
			return;
		}

		ICorporeaSpark spark = CorporeaHelper.instance().getSparkForBlock(field_11863, requestPos);
		if (spark != null) {
			class_2586 te = spark.getSparkNode().getWorld().method_8321(spark.getSparkNode().getPos());
			if (te instanceof ICorporeaRequestor) {
				ICorporeaRequestor requestor = (ICorporeaRequestor) te;
				requestor.doCorporeaRequest(request, requestCount, spark);

				request = null;
				requestCount = 0;
				compValue = 0;
				method_5431();
			}
		}
	}

	@Override
	public void writePacketNBT(class_2487 cmp) {
		super.writePacketNBT(cmp);

		cmp.method_10569(TAG_REQUEST_X, requestPos.method_10263());
		cmp.method_10569(TAG_REQUEST_Y, requestPos.method_10264());
		cmp.method_10569(TAG_REQUEST_Z, requestPos.method_10260());

		class_2960 reqType = request != null ? corporeaMatcherSerializers.get(request.getClass()) : null;

		if (reqType != null) {
			cmp.method_10582(TAG_REQUEST_TYPE, reqType.toString());
			request.writeToNBT(cmp);
			cmp.method_10569(TAG_REQUEST_COUNT, requestCount);
		}
		cmp.method_10556(TAG_RETAIN_MISSING, retainMissing);
	}

	@Override
	public void readPacketNBT(class_2487 cmp) {
		super.readPacketNBT(cmp);

		int x = cmp.method_10550(TAG_REQUEST_X);
		int y = cmp.method_10550(TAG_REQUEST_Y);
		int z = cmp.method_10550(TAG_REQUEST_Z);
		requestPos = new class_2338(x, y, z);

		class_2960 reqType = class_2960.method_12829(cmp.method_10558(TAG_REQUEST_TYPE));
		if (reqType != null && corporeaMatcherDeserializers.containsKey(reqType)) {
			request = corporeaMatcherDeserializers.get(reqType).apply(cmp);
		} else {
			request = null;
		}
		requestCount = cmp.method_10550(TAG_REQUEST_COUNT);
		retainMissing = cmp.method_10577(TAG_RETAIN_MISSING);
	}

	public static <T extends ICorporeaRequestMatcher> void addCorporeaRequestMatcher(class_2960 id, Class<T> clazz, Function<class_2487, T> deserializer) {
		corporeaMatcherSerializers.put(clazz, id);
		corporeaMatcherDeserializers.put(id, deserializer);
	}

	@Environment(EnvType.CLIENT)
	public void renderHUD(class_4587 ms, class_310 mc) {
		String mode = class_1074.method_4662("botaniamisc.retainer." + (retainMissing ? "retain_missing" : "retain_all"));
		int x = mc.method_22683().method_4486() / 2 - mc.field_1772.method_1727(mode) / 2;
		int y = mc.method_22683().method_4502() / 2 + 10;

		mc.field_1772.method_1720(ms, mode, x, y, class_124.field_1080.method_532());
	}

	public boolean onUsedByWand() {
		if (!field_11863.field_9236) {
			retainMissing = !retainMissing;
			method_5431();
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
		}
		return true;
	}
}
