/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile.corporea;

import vazkii.botania.api.corporea.ICorporeaInterceptor;
import vazkii.botania.api.corporea.ICorporeaNode;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.common.block.tile.ModTiles;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1533;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2741;

public class TileCorporeaInterceptor extends TileCorporeaBase implements ICorporeaInterceptor {
	public TileCorporeaInterceptor() {
		super(ModTiles.CORPOREA_INTERCEPTOR);
	}

	@Override
	public void interceptRequest(ICorporeaRequestMatcher request, int count, ICorporeaSpark spark, ICorporeaSpark source, List<class_1799> stacks, List<ICorporeaNode> nodes, boolean doit) {}

	@Override
	public void interceptRequestLast(ICorporeaRequestMatcher request, int count, ICorporeaSpark spark, ICorporeaSpark source, List<class_1799> stacks, List<ICorporeaNode> nodes, boolean doit) {
		List<class_1799> filter = getFilter();
		for (class_1799 stack : filter) {
			if (request.test(stack)) {
				int missing = count;
				for (class_1799 stack_ : stacks) {
					missing -= stack_.method_7947();
				}

				if (missing > 0 && !method_11010().method_11654(class_2741.field_12484)) {
					field_11863.method_8501(method_11016(), method_11010().method_11657(class_2741.field_12484, true));
					field_11863.method_8397().method_8676(method_11016(), method_11010().method_26204(), 2);

					class_2338 requestorPos = source.getSparkNode().getPos();
					for (class_2350 dir : class_2350.values()) {
						class_2586 tile = field_11863.method_8321(field_11867.method_10093(dir));
						if (tile instanceof TileCorporeaRetainer) {
							((TileCorporeaRetainer) tile).remember(requestorPos, request, count, missing);
						}
					}

					return;
				}
			}
		}

	}

	private List<class_1799> getFilter() {
		List<class_1799> filter = new ArrayList<>();

		for (class_2350 dir : class_2350.values()) {
			List<class_1533> frames = field_11863.method_18467(class_1533.class, new class_238(field_11867.method_10093(dir), field_11867.method_10093(dir).method_10069(1, 1, 1)));
			for (class_1533 frame : frames) {
				class_2350 orientation = frame.method_5735();
				if (orientation == dir) {
					filter.add(frame.method_6940());
				}
			}
		}

		return filter;
	}

}
