/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile.corporea;

import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;
import vazkii.botania.api.corporea.ICorporeaRequestor;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.core.helper.InventoryHelper;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1533;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2614;

public class TileCorporeaFunnel extends TileCorporeaBase implements ICorporeaRequestor {
	public TileCorporeaFunnel() {
		super(ModTiles.CORPOREA_FUNNEL);
	}

	public void doRequest() {
		ICorporeaSpark spark = getSpark();
		if (spark != null && spark.getMaster() != null) {
			List<class_1799> filter = getFilter();
			if (!filter.isEmpty()) {
				class_1799 stack = filter.get(field_11863.field_9229.nextInt(filter.size()));

				if (!stack.method_7960()) {
					doCorporeaRequest(CorporeaHelper.instance().createMatcher(stack, true), stack.method_7947(), spark);
				}
			}
		}
	}

	public List<class_1799> getFilter() {
		List<class_1799> filter = new ArrayList<>();

		final int[] rotationToStackSize = new int[] {
				1, 2, 4, 8, 16, 32, 48, 64
		};

		for (class_2350 dir : class_2350.values()) {
			List<class_1533> frames = field_11863.method_18467(class_1533.class, new class_238(field_11867.method_10093(dir), field_11867.method_10093(dir).method_10069(1, 1, 1)));
			for (class_1533 frame : frames) {
				class_2350 orientation = frame.method_5735();
				if (orientation == dir) {
					class_1799 stack = frame.method_6940();
					if (!stack.method_7960()) {
						class_1799 copy = stack.method_7972();
						copy.method_7939(rotationToStackSize[frame.method_6934()]);
						filter.add(copy);
					}
				}
			}
		}

		return filter;
	}

	@Override
	public void doCorporeaRequest(ICorporeaRequestMatcher request, int count, ICorporeaSpark spark) {
		class_1263 inv = getInv();

		List<class_1799> stacks = CorporeaHelper.instance().requestItem(request, count, spark, true).getStacks();
		spark.onItemsRequested(stacks);
		for (class_1799 reqStack : stacks) {
			if (inv != null && InventoryHelper.simulateTransfer(inv, reqStack, class_2350.field_11036).method_7960()) {
				class_2614.method_11260(null, inv, reqStack, class_2350.field_11036);
			} else {
				class_1542 item = new class_1542(field_11863, field_11867.method_10263() + 0.5, field_11867.method_10264() + 1.5, field_11867.method_10260() + 0.5, reqStack);
				field_11863.method_8649(item);
			}
		}
	}

	private class_1263 getInv() {
		class_2586 te = field_11863.method_8321(field_11867.method_10074());
		class_1263 ret = InventoryHelper.getInventory(field_11863, field_11867.method_10074(), class_2350.field_11036);
		if (ret == null) {
			ret = InventoryHelper.getInventory(field_11863, field_11867.method_10074(), null);
		}
		if (ret != null && !(te instanceof TileCorporeaFunnel)) {
			return ret;
		}

		te = field_11863.method_8321(field_11867.method_10087(2));
		ret = InventoryHelper.getInventory(field_11863, field_11867.method_10087(2), class_2350.field_11036);
		if (ret == null) {
			ret = InventoryHelper.getInventory(field_11863, field_11867.method_10087(2), null);
		}
		if (ret != null && !(te instanceof TileCorporeaFunnel)) {
			return ret;
		}

		return null;
	}

}
