/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile.corporea;

import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;
import vazkii.botania.api.corporea.ICorporeaRequestor;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.tile.ModTiles;

import java.util.List;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3000;

public class TileCorporeaCrystalCube extends TileCorporeaBase implements ICorporeaRequestor, class_3000 {
	private static final String TAG_REQUEST_TARGET = "requestTarget";
	private static final String TAG_ITEM_COUNT = "itemCount";
	private static final String TAG_LOCK = "lock";

	private class_1799 requestTarget = class_1799.field_8037;
	private int itemCount = 0;
	private int ticks = 0;
	private int compValue = 0;
	public boolean locked = false;

	public TileCorporeaCrystalCube() {
		super(ModTiles.CORPOREA_CRYSTAL_CUBE);
	}

	@Override
	public void method_16896() {
		++ticks;
		if (ticks % 20 == 0) {
			updateCount();
		}
	}

	public void setRequestTarget(class_1799 stack) {
		if (!stack.method_7960() && !locked) {
			class_1799 copy = stack.method_7972();
			copy.method_7939(1);
			requestTarget = copy;
			updateCount();
			if (!field_11863.field_9236) {
				VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
			}
		}

	}

	public class_1799 getRequestTarget() {
		return requestTarget;
	}

	public int getItemCount() {
		return itemCount;
	}

	public void doRequest(boolean fullStack) {
		if (field_11863.field_9236) {
			return;
		}

		ICorporeaSpark spark = getSpark();
		if (spark != null && spark.getMaster() != null && requestTarget != null) {
			int count = fullStack ? requestTarget.method_7914() : 1;
			doCorporeaRequest(CorporeaHelper.instance().createMatcher(requestTarget, true), count, spark);
		}
	}

	private void updateCount() {
		if (field_11863.field_9236) {
			return;
		}

		int oldCount = itemCount;
		itemCount = 0;
		ICorporeaSpark spark = getSpark();
		if (spark != null && spark.getMaster() != null && requestTarget != null) {
			List<class_1799> stacks = CorporeaHelper.instance().requestItem(CorporeaHelper.instance().createMatcher(requestTarget, true), -1, spark, false).getStacks();
			for (class_1799 stack : stacks) {
				itemCount += stack.method_7947();
			}
		}

		if (itemCount != oldCount) {
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
			onUpdateCount();
		}
	}

	private void onUpdateCount() {
		int oldCompValue = compValue;
		compValue = CorporeaHelper.instance().signalStrengthForRequestSize(itemCount);
		if (compValue != oldCompValue) {
			field_11863.method_8455(field_11867, method_11010().method_26204());
		}
	}

	@Override
	public void writePacketNBT(class_2487 tag) {
		super.writePacketNBT(tag);
		class_2487 cmp = new class_2487();
		if (!requestTarget.method_7960()) {
			cmp = requestTarget.method_7953(cmp);
		}
		tag.method_10566(TAG_REQUEST_TARGET, cmp);
		tag.method_10569(TAG_ITEM_COUNT, itemCount);
		tag.method_10556(TAG_LOCK, locked);
	}

	@Override
	public void readPacketNBT(class_2487 tag) {
		super.readPacketNBT(tag);
		class_2487 cmp = tag.method_10562(TAG_REQUEST_TARGET);
		requestTarget = class_1799.method_7915(cmp);
		itemCount = tag.method_10550(TAG_ITEM_COUNT);
		locked = tag.method_10577(TAG_LOCK);
	}

	public int getComparatorValue() {
		return compValue;
	}

	@Override
	public void doCorporeaRequest(ICorporeaRequestMatcher request, int count, ICorporeaSpark spark) {
		List<class_1799> stacks = CorporeaHelper.instance().requestItem(request, count, spark, true).getStacks();
		spark.onItemsRequested(stacks);
		boolean did = false;
		for (class_1799 reqStack : stacks) {
			if (requestTarget != null) {
				class_1542 item = new class_1542(field_11863, field_11867.method_10263() + 0.5, field_11867.method_10264() + 1.5, field_11867.method_10260() + 0.5, reqStack);
				field_11863.method_8649(item);
				itemCount -= reqStack.method_7947();
				did = true;
			}
		}

		if (did) {
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
			onUpdateCount();
		}
	}
}
