/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile;

import net.minecraft.class_1268;
import net.minecraft.class_1275;
import net.minecraft.class_1277;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3000;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.util.*;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.ModStats;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.PlayerHelper;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class TileTinyPotato extends TileExposedSimpleInventory implements class_3000, class_1275 {
	private static final String TAG_NAME = "name";
	private static final int JUMP_EVENT = 0;

	public int jumpTicks = 0;
	public class_2561 name = new class_2585("");
	private int nextDoIt = 0;

	public TileTinyPotato() {
		super(ModTiles.TINY_POTATO);
	}

	public void interact(class_1657 player, class_1268 hand, class_1799 stack, class_2350 side) {
		int index = side.method_10146();
		if (index >= 0) {
			class_1799 stackAt = getItemHandler().method_5438(index);
			if (!stackAt.method_7960() && stack.method_7960()) {
				player.method_6122(hand, stackAt);
				getItemHandler().method_5447(index, class_1799.field_8037);
			} else if (!stack.method_7960()) {
				class_1799 copy = stack.method_7971(1);

				if (stack.method_7960()) {
					player.method_6122(hand, stackAt);
				} else if (!stackAt.method_7960()) {
					player.field_7514.method_7398(player.field_6002, stackAt);
				}

				getItemHandler().method_5447(index, copy);
			}
		}

		if (!field_11863.field_9236) {
			jump();

			if (name.getString().toLowerCase().trim().endsWith("shia labeouf") && nextDoIt == 0) {
				nextDoIt = 40;
				field_11863.method_8396(null, field_11867, ModSounds.doit, class_3419.field_15245, 1F, 1F);
			}

			for (int i = 0; i < inventorySize(); i++) {
				class_1799 stackAt = getItemHandler().method_5438(i);
				if (!stackAt.method_7960() && stackAt.method_7909() == ModBlocks.tinyPotato.method_8389()) {
					player.method_9203(new class_2585("Don't talk to me or my son ever again."), class_156.field_25140);
					return;
				}
			}

			player.method_7281(ModStats.TINY_POTATOES_PETTED);
			PlayerHelper.grantCriterion((class_3222) player, prefix("main/tiny_potato_pet"), "code_triggered");
		}
	}

	private void jump() {
		if (jumpTicks == 0) {
			field_11863.method_8427(method_11016(), method_11010().method_26204(), JUMP_EVENT, 20);
		}
	}

	@Override
	public boolean method_11004(int id, int param) {
		if (id == JUMP_EVENT) {
			jumpTicks = param;
			return true;
		} else {
			return super.method_11004(id, param);
		}
	}

	@Override
	public void method_16896() {
		if (jumpTicks > 0) {
			jumpTicks--;
		}

		if (!field_11863.field_9236) {
			if (field_11863.field_9229.nextInt(100) == 0) {
				jump();
			}
			if (nextDoIt > 0) {
				nextDoIt--;
			}
		}
	}

	@Override
	public void method_5431() {
		super.method_5431();
		if (field_11863 != null && !field_11863.field_9236) {
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
		}
	}

	@Override
	public void writePacketNBT(class_2487 cmp) {
		super.writePacketNBT(cmp);
		cmp.method_10582(TAG_NAME, class_2561.class_2562.method_10867(name));
	}

	@Override
	public void readPacketNBT(class_2487 cmp) {
		super.readPacketNBT(cmp);
		name = class_2561.class_2562.method_10877(cmp.method_10558(TAG_NAME));
	}

	@Override
	protected class_1277 createItemHandler() {
		return new class_1277(6);
	}

	@Nonnull
	@Override
	public class_2561 method_5477() {
		return new class_2588(ModBlocks.tinyPotato.method_9539());
	}

	@Nullable
	@Override
	public class_2561 method_5797() {
		return name.getString().isEmpty() ? null : name;
	}

	@Nonnull
	@Override
	public class_2561 method_5476() {
		return method_16914() ? method_5797() : method_5477();
	}
}
